/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.jcip.annotations.ThreadSafe;
import org.gradle.api.Transformer;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.registry.ModelBinding;
import org.gradle.model.internal.registry.RuleBinder;
import org.gradle.model.internal.report.unbound.UnboundRule;
import org.gradle.model.internal.report.unbound.UnboundRuleInput;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class UnboundRulesProcessor {
    private final Iterable<? extends RuleBinder> binders;
    private final Transformer<? extends Collection<? extends ModelPath>, ? super ModelPath> suggestionsProvider;

    public UnboundRulesProcessor(Iterable<? extends RuleBinder> binders, Transformer<? extends Collection<? extends ModelPath>, ? super ModelPath> suggestionsProvider) {
        this.binders = binders;
        this.suggestionsProvider = suggestionsProvider;
    }

    public List<? extends UnboundRule> process() {
        ArrayList<UnboundRule> unboundRules = new ArrayList<UnboundRule>();
        for (RuleBinder ruleBinder : this.binders) {
            UnboundRule.Builder builder = UnboundRule.descriptor(ruleBinder.getDescriptor().toString());
            ModelPath scope = ruleBinder.getScope();
            if (ruleBinder.getSubjectReference() != null) {
                ModelBinding<?> binding = ruleBinder.getSubjectBinding();
                ModelReference<?> reference = ruleBinder.getSubjectReference();
                UnboundRuleInput.Builder inputBuilder = this.toInputBuilder(binding, reference, scope);
                if (scope != ModelPath.ROOT) {
                    inputBuilder.scope(scope.toString());
                }
                builder.mutableInput(inputBuilder);
            }
            for (int i = 0; i < ruleBinder.getInputReferences().size(); ++i) {
                ModelBinding<?> binding = ruleBinder.getInputBindings().get(i);
                ModelReference<?> reference = ruleBinder.getInputReferences().get(i);
                builder.immutableInput(this.toInputBuilder(binding, reference, ruleBinder.getScope()));
            }
            unboundRules.add(builder.build());
        }
        return unboundRules;
    }

    private UnboundRuleInput.Builder toInputBuilder(ModelBinding<?> binding, ModelReference<?> reference, ModelPath scope) {
        ModelPath path;
        UnboundRuleInput.Builder builder = UnboundRuleInput.type(reference.getType());
        if (binding != null) {
            builder.bound();
            path = binding.getNode().getPath();
        } else {
            path = reference.getPath();
            if (path != null) {
                path = scope.descendant(path);
                builder.suggestions(CollectionUtils.stringize((Collection)((Collection)this.suggestionsProvider.transform((Object)path))));
            }
        }
        if (path != null) {
            builder.path(path);
        }
        builder.description(reference.getDescription());
        return builder;
    }
}

