/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.type;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.gradle.model.internal.type.ModelType;
import org.gradle.model.internal.type.TypeWrapper;

class ParameterizedTypeWrapper
implements ParameterizedType,
TypeWrapper {
    private final TypeWrapper[] actualTypeArguments;
    private final TypeWrapper rawType;
    private final TypeWrapper ownerType;
    private final int hashCode;

    public ParameterizedTypeWrapper(TypeWrapper[] actualTypeArguments, TypeWrapper rawType, TypeWrapper ownerType, int hashCode) {
        this.actualTypeArguments = actualTypeArguments;
        this.rawType = rawType;
        this.ownerType = ownerType;
        this.hashCode = hashCode;
    }

    public Type[] getActualTypeArguments() {
        return ModelType.unwrap(this.actualTypeArguments);
    }

    public Type getRawType() {
        return this.rawType.unwrap();
    }

    public Type getOwnerType() {
        return this.ownerType.unwrap();
    }

    public Type unwrap() {
        return this;
    }

    public boolean equals(Object o) {
        if (o instanceof ParameterizedType) {
            ParameterizedType that = (ParameterizedType)o;
            if (this == that) {
                return true;
            }
            Type ownerType = this.getOwnerType();
            Type rawType = this.getRawType();
            Type thatOwner = that.getOwnerType();
            Type thatRawType = that.getRawType();
            return (ownerType == null ? thatOwner == null : ownerType.equals(thatOwner)) && (rawType == null ? thatRawType == null : rawType.equals(thatRawType)) && Arrays.equals(this.getActualTypeArguments(), that.getActualTypeArguments());
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Type ownerType = this.getOwnerType();
        Class rawType = (Class)this.getRawType();
        if (ownerType != null) {
            if (ownerType instanceof Class) {
                sb.append(((Class)ownerType).getName());
            } else {
                sb.append(ownerType.toString());
            }
            sb.append(".");
            if (ownerType instanceof ParameterizedTypeWrapper) {
                Class ownerRaw = (Class)((ParameterizedTypeWrapper)ownerType).rawType.unwrap();
                sb.append(rawType.getName().replace(ownerRaw.getName() + "$", ""));
            } else {
                sb.append(rawType.getName());
            }
        } else {
            sb.append(rawType.getName());
        }
        Type[] actualTypeArguments = this.getActualTypeArguments();
        if (actualTypeArguments != null && actualTypeArguments.length > 0) {
            sb.append("<");
            boolean first = true;
            for (Type t : actualTypeArguments) {
                if (!first) {
                    sb.append(", ");
                }
                if (t instanceof Class) {
                    sb.append(((Class)t).getName());
                } else {
                    sb.append(t.toString());
                }
                first = false;
            }
            sb.append(">");
        }
        return sb.toString();
    }

    public String getRepresentation() {
        return this.toString();
    }
}

