/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.type;

import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import org.gradle.model.internal.type.ModelType;
import org.gradle.model.internal.type.TypeWrapper;

class WildcardTypeWrapper
implements WildcardType,
TypeWrapper {
    private final TypeWrapper[] upperBounds;
    private final TypeWrapper[] lowerBounds;
    private final int hashCode;

    public WildcardTypeWrapper(TypeWrapper[] upperBounds, TypeWrapper[] lowerBounds, int hashCode) {
        this.upperBounds = upperBounds;
        this.lowerBounds = lowerBounds;
        this.hashCode = hashCode;
    }

    public Type[] getUpperBounds() {
        return ModelType.unwrap(this.upperBounds);
    }

    public Type[] getLowerBounds() {
        return ModelType.unwrap(this.lowerBounds);
    }

    public Type unwrap() {
        return this;
    }

    public boolean equals(Object o) {
        if (!(o instanceof WildcardType)) {
            return false;
        }
        WildcardType var2 = (WildcardType)o;
        return Arrays.equals(this.getLowerBounds(), var2.getLowerBounds()) && Arrays.equals(this.getUpperBounds(), var2.getUpperBounds());
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        Type[] lowerBounds;
        Type[] bounds = lowerBounds = this.getLowerBounds();
        StringBuilder sb = new StringBuilder();
        if (lowerBounds.length > 0) {
            sb.append("? super ");
        } else {
            Type[] upperBounds = this.getUpperBounds();
            if (upperBounds.length > 0 && !upperBounds[0].equals(Object.class)) {
                bounds = upperBounds;
                sb.append("? extends ");
            } else {
                return "?";
            }
        }
        assert (bounds.length > 0);
        boolean first = true;
        for (Type bound : bounds) {
            if (!first) {
                sb.append(" & ");
            }
            first = false;
            if (bound instanceof Class) {
                sb.append(((Class)bound).getName());
                continue;
            }
            sb.append(bound.toString());
        }
        return sb.toString();
    }

    public String getRepresentation() {
        return this.toString();
    }
}

