/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.mvn3.org.apache.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.gradle.mvn3.org.apache.maven.artifact.Artifact;
import org.gradle.mvn3.org.apache.maven.artifact.ArtifactUtils;
import org.gradle.mvn3.org.apache.maven.project.MavenProject;
import org.gradle.mvn3.org.sonatype.aether.repository.WorkspaceReader;
import org.gradle.mvn3.org.sonatype.aether.repository.WorkspaceRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReactorReader
implements WorkspaceReader {
    private Map<String, MavenProject> projectsByGAV;
    private Map<String, List<MavenProject>> projectsByGA;
    private WorkspaceRepository repository;

    public ReactorReader(Map<String, MavenProject> reactorProjects) {
        this.projectsByGAV = reactorProjects;
        this.projectsByGA = new HashMap<String, List<MavenProject>>(reactorProjects.size() * 2);
        for (MavenProject project : reactorProjects.values()) {
            String key = ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId());
            List<MavenProject> projects = this.projectsByGA.get(key);
            if (projects == null) {
                projects = new ArrayList<MavenProject>(1);
                this.projectsByGA.put(key, projects);
            }
            projects.add(project);
        }
        this.repository = new WorkspaceRepository("reactor", new HashSet<String>(this.projectsByGAV.keySet()));
    }

    private File find(MavenProject project, org.gradle.mvn3.org.sonatype.aether.artifact.Artifact artifact) {
        if ("pom".equals(artifact.getExtension())) {
            return project.getFile();
        }
        Artifact projectArtifact = this.findMatchingArtifact(project, artifact);
        if (this.hasArtifactFileFromPackagePhase(projectArtifact)) {
            return projectArtifact.getFile();
        }
        if (!this.hasBeenPackaged(project)) {
            if (ReactorReader.isTestArtifact(artifact)) {
                if (project.hasLifecyclePhase("test-compile")) {
                    return new File(project.getBuild().getTestOutputDirectory());
                }
            } else if (project.hasLifecyclePhase("compile")) {
                return new File(project.getBuild().getOutputDirectory());
            }
        }
        return null;
    }

    private boolean hasArtifactFileFromPackagePhase(Artifact projectArtifact) {
        return projectArtifact != null && projectArtifact.getFile() != null && projectArtifact.getFile().exists();
    }

    private boolean hasBeenPackaged(MavenProject project) {
        return project.hasLifecyclePhase("package") || project.hasLifecyclePhase("install") || project.hasLifecyclePhase("deploy");
    }

    private Artifact findMatchingArtifact(MavenProject project, org.gradle.mvn3.org.sonatype.aether.artifact.Artifact requestedArtifact) {
        Artifact mainArtifact;
        String requestedRepositoryConflictId = this.getConflictId(requestedArtifact);
        if (requestedRepositoryConflictId.equals(this.getConflictId(mainArtifact = project.getArtifact()))) {
            return mainArtifact;
        }
        List<Artifact> attachedArtifacts = project.getAttachedArtifacts();
        if (attachedArtifacts != null && !attachedArtifacts.isEmpty()) {
            for (Artifact attachedArtifact : attachedArtifacts) {
                if (!requestedRepositoryConflictId.equals(this.getConflictId(attachedArtifact))) continue;
                return attachedArtifact;
            }
        }
        return null;
    }

    private String getConflictId(Artifact artifact) {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(artifact.getGroupId());
        buffer.append(':').append(artifact.getArtifactId());
        if (artifact.getArtifactHandler() != null) {
            buffer.append(':').append(artifact.getArtifactHandler().getExtension());
        } else {
            buffer.append(':').append(artifact.getType());
        }
        if (artifact.hasClassifier()) {
            buffer.append(':').append(artifact.getClassifier());
        }
        return buffer.toString();
    }

    private String getConflictId(org.gradle.mvn3.org.sonatype.aether.artifact.Artifact artifact) {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(artifact.getGroupId());
        buffer.append(':').append(artifact.getArtifactId());
        buffer.append(':').append(artifact.getExtension());
        if (artifact.getClassifier().length() > 0) {
            buffer.append(':').append(artifact.getClassifier());
        }
        return buffer.toString();
    }

    private static boolean isTestArtifact(org.gradle.mvn3.org.sonatype.aether.artifact.Artifact artifact) {
        return "test-jar".equals(artifact.getProperty("type", "")) || "jar".equals(artifact.getExtension()) && "tests".equals(artifact.getClassifier());
    }

    public File findArtifact(org.gradle.mvn3.org.sonatype.aether.artifact.Artifact artifact) {
        String projectKey = ArtifactUtils.key((String)artifact.getGroupId(), (String)artifact.getArtifactId(), (String)artifact.getVersion());
        MavenProject project = this.projectsByGAV.get(projectKey);
        if (project != null) {
            File file = this.find(project, artifact);
            if (file == null && project != project.getExecutionProject()) {
                file = this.find(project.getExecutionProject(), artifact);
            }
            return file;
        }
        return null;
    }

    public List<String> findVersions(org.gradle.mvn3.org.sonatype.aether.artifact.Artifact artifact) {
        String key = ArtifactUtils.versionlessKey((String)artifact.getGroupId(), (String)artifact.getArtifactId());
        List<MavenProject> projects = this.projectsByGA.get(key);
        if (projects == null || projects.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> versions = new ArrayList<String>();
        for (MavenProject project : projects) {
            if (this.find(project, artifact) == null) continue;
            versions.add(project.getVersion());
        }
        return Collections.unmodifiableList(versions);
    }

    public WorkspaceRepository getRepository() {
        return this.repository;
    }
}

