/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.mvn3.org.apache.maven.toolchain;

import java.util.HashMap;
import java.util.Map;
import org.gradle.mvn3.org.apache.maven.execution.MavenSession;
import org.gradle.mvn3.org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.gradle.mvn3.org.apache.maven.project.MavenProject;
import org.gradle.mvn3.org.apache.maven.toolchain.MisconfiguredToolchainException;
import org.gradle.mvn3.org.apache.maven.toolchain.Toolchain;
import org.gradle.mvn3.org.apache.maven.toolchain.ToolchainFactory;
import org.gradle.mvn3.org.apache.maven.toolchain.ToolchainManager;
import org.gradle.mvn3.org.apache.maven.toolchain.model.ToolchainModel;
import org.gradle.mvn3.org.codehaus.plexus.component.annotations.Component;
import org.gradle.mvn3.org.codehaus.plexus.component.annotations.Requirement;
import org.gradle.mvn3.org.codehaus.plexus.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=ToolchainManager.class)
public class DefaultToolchainManager
implements ToolchainManager {
    @Requirement
    Logger logger;
    @Requirement(role=ToolchainFactory.class)
    Map<String, ToolchainFactory> factories;

    @Override
    public Toolchain getToolchainFromBuildContext(String type, MavenSession session) {
        Map<String, Object> context = this.retrieveContext(session);
        ToolchainModel model = (ToolchainModel)context.get(DefaultToolchainManager.getStorageKey(type));
        if (model != null) {
            try {
                ToolchainFactory fact = this.factories.get(type);
                if (fact != null) {
                    return fact.createToolchain(model);
                }
                this.logger.error("Missing toolchain factory for type: " + type + ". Possibly caused by misconfigured project.");
            }
            catch (MisconfiguredToolchainException ex) {
                this.logger.error("Misconfigured toolchain.", (Throwable)ex);
            }
        }
        return null;
    }

    Map<String, Object> retrieveContext(MavenSession session) {
        Map<Object, Object> context = null;
        if (session != null) {
            PluginDescriptor desc = new PluginDescriptor();
            desc.setGroupId(PluginDescriptor.getDefaultPluginGroupId());
            desc.setArtifactId(PluginDescriptor.getDefaultPluginArtifactId((String)"toolchains"));
            MavenProject current = session.getCurrentProject();
            if (current != null) {
                context = session.getPluginContext(desc, current);
            }
        }
        return context != null ? context : new HashMap();
    }

    public static final String getStorageKey(String type) {
        return "toolchain-" + type;
    }
}

