/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea;

import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.keymap.impl.KeymapManagerImpl;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.messages.MessageBus;
import org.jetbrains.annotations.NonNls;

public class AndroidInitialConfigurator {
    @NonNls
    private static final ExtensionPointName<Runnable> EP_NAME = ExtensionPointName.create((String)"com.intellij.androidStudioInitializer");
    @NonNls
    private static final String CONFIG_V1 = "AndroidInitConfigurator.V1";
    @NonNls
    private static final String CONFIG_V2 = "AndroidInitConfigurator.V2";
    @NonNls
    private static final String CONFIG_V3 = "AndroidInitConfigurator.V3";
    @NonNls
    private static final String CONFIG_V4 = "AndroidInitConfigurator.V4";
    @NonNls
    private static final String TODO_TOOLWINDOW_ACTION_ID = "ActivateTODOToolWindow";
    @NonNls
    private static final String ANDROID_TOOLWINDOW_ACTION_ID = "ActivateAndroidMonitorToolWindow";

    public AndroidInitialConfigurator(MessageBus bus, PropertiesComponent propertiesComponent, FileTypeManager fileTypeManager) {
        AndroidInitialConfigurator.validateConfiguration();
        AndroidInitialConfigurator.setupSystemProperties();
        AndroidInitialConfigurator.customizeSettings(propertiesComponent);
        AndroidInitialConfigurator.setActivateAndroidToolWindowShortcut();
        AndroidInitialConfigurator.activateAndroidStudioInitializerExtensions();
    }

    private static void validateConfiguration() {
        String[] versions;
        for (String version : versions = new String[]{ApplicationInfo.getInstance().getMajorVersion(), ApplicationInfo.getInstance().getMinorVersion(), ApplicationInfo.getInstance().getMicroVersion(), ApplicationInfo.getInstance().getPatchVersion()}) {
            if (version == null || !version.matches("0|([1-9]+[0-9]*)")) {
                throw new AssertionError((Object)("Invalid version component found: " + version));
            }
        }
    }

    private static void setupSystemProperties() {
        String updateUrl = System.getenv("AS_UPDATE_URL");
        if (updateUrl != null) {
            if (!updateUrl.endsWith("/")) {
                updateUrl = updateUrl + "/";
            }
            System.setProperty("idea.updates.url", updateUrl + "updates.xml");
            System.setProperty("idea.patches.url", updateUrl);
        }
    }

    private static void customizeSettings(PropertiesComponent propertiesComponent) {
        if (!propertiesComponent.getBoolean(CONFIG_V4, false)) {
            propertiesComponent.setValue(CONFIG_V4, "true");
            UISettings.getInstance().HIDE_TOOL_STRIPES = false;
            if (!propertiesComponent.getBoolean(CONFIG_V3, false)) {
                propertiesComponent.setValue(CONFIG_V3, "true");
                WebEditorOptions.getInstance().setInsertQuotesForAttributeValue(false);
            }
            if (!propertiesComponent.getBoolean(CONFIG_V1, false)) {
                propertiesComponent.setValue(CONFIG_V1, "true");
                CodeInsightSettings.getInstance().AUTO_POPUP_JAVADOC_INFO = true;
                UISettings.getInstance().SCROLL_TAB_LAYOUT_IN_EDITOR = true;
                EditorSettingsExternalizable.getInstance().setVirtualSpace(false);
                if (SystemInfo.isMac) {
                    AndroidInitialConfigurator.setDefaultMacKeymap();
                }
            }
            if (!propertiesComponent.getBoolean(CONFIG_V2, false)) {
                propertiesComponent.setValue(CONFIG_V2, "true");
                UISettings.getInstance().SHOW_MAIN_TOOLBAR = true;
            }
        }
    }

    private static void setDefaultMacKeymap() {
        KeymapManagerImpl instance = (KeymapManagerImpl)KeymapManager.getInstance();
        Keymap mac105Keymap = AndroidInitialConfigurator.getMac105Keymap();
        if (mac105Keymap != null) {
            instance.setActiveKeymap(mac105Keymap);
        }
    }

    private static Keymap getMac105Keymap() {
        for (Keymap keymap : KeymapManagerEx.getInstanceEx().getAllKeymaps()) {
            if (!keymap.getName().contains("10.5")) continue;
            return keymap;
        }
        return null;
    }

    private static void setActivateAndroidToolWindowShortcut() {
        Keymap defaultKeymap = null;
        for (Keymap keymap : KeymapManagerEx.getInstanceEx().getAllKeymaps()) {
            if ("$default".equals(keymap.getName())) {
                defaultKeymap = keymap;
                continue;
            }
            AndroidInitialConfigurator.setActivateAndroidToolWindowShortcut(keymap);
        }
        if (defaultKeymap != null) {
            AndroidInitialConfigurator.setActivateAndroidToolWindowShortcut(defaultKeymap);
        }
    }

    private static void setActivateAndroidToolWindowShortcut(Keymap keymap) {
        KeyboardShortcut shortcut = AndroidInitialConfigurator.removeFirstKeyboardShortcut(keymap, TODO_TOOLWINDOW_ACTION_ID);
        if (shortcut != null) {
            keymap.addShortcut(ANDROID_TOOLWINDOW_ACTION_ID, (Shortcut)shortcut);
        }
    }

    private static KeyboardShortcut removeFirstKeyboardShortcut(Keymap keymap, String actionId) {
        Shortcut[] shortcuts;
        for (Shortcut each : shortcuts = keymap.getShortcuts(actionId)) {
            if (!(each instanceof KeyboardShortcut)) continue;
            keymap.removeShortcut(actionId, each);
            return (KeyboardShortcut)each;
        }
        return null;
    }

    private static void activateAndroidStudioInitializerExtensions() {
        Runnable[] extensions;
        for (Runnable r : extensions = (Runnable[])EP_NAME.getExtensions()) {
            r.run();
        }
    }
}

