/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.Location;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Set;

public class ExcludeFromRunAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)("#" + ExcludeFromRunAction.class.getName()));

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        LOG.assertTrue(project != null);
        JUnitConfiguration configuration = (JUnitConfiguration)((Object)RunConfiguration.DATA_KEY.getData(dataContext));
        LOG.assertTrue(configuration != null);
        GlobalSearchScope searchScope = ((JavaRunConfigurationModule)configuration.getConfigurationModule()).getSearchScope();
        Set<String> patterns = configuration.getPersistentData().getPatterns();
        AbstractTestProxy testProxy = (AbstractTestProxy)AbstractTestProxy.DATA_KEY.getData(dataContext);
        LOG.assertTrue(testProxy != null);
        patterns.remove(((PsiClass)testProxy.getLocation(project, searchScope).getPsiElement()).getQualifiedName());
    }

    public void update(AnActionEvent e) {
        RunConfiguration configuration;
        Presentation presentation = e.getPresentation();
        presentation.setVisible(false);
        DataContext dataContext = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project != null && (configuration = (RunConfiguration)RunConfiguration.DATA_KEY.getData(dataContext)) instanceof JUnitConfiguration) {
            PsiElement psiElement;
            Location location;
            AbstractTestProxy testProxy;
            JUnitConfiguration.Data data = ((JUnitConfiguration)configuration).getPersistentData();
            if (data.TEST_OBJECT == "pattern" && (testProxy = (AbstractTestProxy)AbstractTestProxy.DATA_KEY.getData(dataContext)) != null && (location = testProxy.getLocation(project, ((JavaRunConfigurationModule)((JUnitConfiguration)configuration).getConfigurationModule()).getSearchScope())) != null && (psiElement = location.getPsiElement()) instanceof PsiClass && data.getPatterns().contains(((PsiClass)psiElement).getQualifiedName())) {
                presentation.setVisible(true);
            }
        }
    }
}

