/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.testIntegration.JavaTestFramework;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;

public class JUnit4Framework
extends JavaTestFramework {
    private static final Logger LOG = Logger.getInstance((String)("#" + JUnit4Framework.class.getName()));

    public String getName() {
        return "JUnit4";
    }

    public Icon getIcon() {
        return AllIcons.RunConfigurations.Junit;
    }

    protected String getMarkerClassFQName() {
        return "org.junit.Test";
    }

    public String getLibraryPath() {
        return JavaSdkUtil.getJunit4JarPath();
    }

    public String getDefaultSuperClass() {
        return null;
    }

    public boolean isTestClass(PsiClass clazz, boolean canBePotential) {
        if (canBePotential) {
            return this.isUnderTestSources(clazz);
        }
        return JUnitUtil.isJUnit4TestClass((PsiClass)clazz);
    }

    protected PsiMethod findSetUpMethod(PsiClass clazz) {
        for (PsiMethod each : clazz.getMethods()) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)each, (String)"org.junit.Before", (boolean)false)) continue;
            return each;
        }
        return null;
    }

    protected PsiMethod findTearDownMethod(PsiClass clazz) {
        for (PsiMethod each : clazz.getMethods()) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)each, (String)"org.junit.After", (boolean)false)) continue;
            return each;
        }
        return null;
    }

    protected PsiMethod findOrCreateSetUpMethod(PsiClass clazz) throws IncorrectOperationException {
        PsiMethod testMethod;
        PsiMethod method = this.findSetUpMethod(clazz);
        if (method != null) {
            return method;
        }
        PsiManager manager = clazz.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        method = this.createSetUpPatternMethod((JVMElementFactory)factory);
        PsiMethod existingMethod = clazz.findMethodBySignature(method, false);
        if (existingMethod != null) {
            int exit;
            int n = exit = ApplicationManager.getApplication().isUnitTestMode() ? 0 : Messages.showOkCancelDialog((String)"Method setUp already exist but is not annotated as @Before. Annotate?", (String)CommonBundle.getWarningTitle(), (Icon)Messages.getWarningIcon());
            if (exit == 0) {
                new AddAnnotationFix("org.junit.Before", (PsiModifierListOwner)existingMethod, new String[0]).invoke(existingMethod.getProject(), null, existingMethod.getContainingFile());
                return existingMethod;
            }
        }
        method = (testMethod = JUnitUtil.findFirstTestMethod((PsiClass)clazz)) != null ? (PsiMethod)clazz.addBefore((PsiElement)method, (PsiElement)testMethod) : (PsiMethod)clazz.add((PsiElement)method);
        JavaCodeStyleManager.getInstance((Project)manager.getProject()).shortenClassReferences((PsiElement)method);
        return method;
    }

    public boolean isIgnoredMethod(PsiElement element) {
        PsiMethod testMethod = element instanceof PsiMethod ? JUnitUtil.getTestMethod((PsiElement)element) : null;
        return testMethod != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)testMethod, (String)"org.junit.Ignore", (boolean)false);
    }

    public boolean isTestMethod(PsiElement element) {
        return element instanceof PsiMethod && JUnitUtil.getTestMethod((PsiElement)element) != null;
    }

    public FileTemplateDescriptor getSetUpMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("JUnit4 SetUp Method.java");
    }

    public FileTemplateDescriptor getTearDownMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("JUnit4 TearDown Method.java");
    }

    public FileTemplateDescriptor getTestMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("JUnit4 Test Method.java");
    }

    public FileTemplateDescriptor getParametersMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("JUnit4 Parameters Method.java");
    }

    public char getMnemonic() {
        return '4';
    }

    public FileTemplateDescriptor getTestClassFileTemplateDescriptor() {
        return new FileTemplateDescriptor("JUnit4 Test Class.java");
    }

    public void setupLibrary(Module module) {
        try {
            OrderEntryFix.addJUnit4Library((boolean)false, (Module)module);
        }
        catch (ClassNotFoundException e) {
            LOG.info((Throwable)e);
        }
    }

    public boolean isParameterized(PsiClass clazz) {
        PsiAnnotationMemberValue value;
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)clazz, (String[])new String[]{"org.junit.runner.RunWith"});
        if (annotation != null && (value = annotation.findAttributeValue("value")) instanceof PsiClassObjectAccessExpression) {
            PsiTypeElement operand = ((PsiClassObjectAccessExpression)value).getOperand();
            PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)operand.getType());
            return psiClass != null && "org.junit.runners.Parameterized".equals(psiClass.getQualifiedName());
        }
        return false;
    }

    public PsiMethod findParametersMethod(PsiClass clazz) {
        PsiMethod[] methods;
        for (PsiMethod method : methods = clazz.getAllMethods()) {
            if (!method.hasModifierProperty("public") || !method.hasModifierProperty("static") || !AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"org.junit.runners.Parameterized.Parameters", (boolean)false)) continue;
            return method;
        }
        return null;
    }
}

