/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.info;

import com.intellij.execution.Location;
import com.intellij.execution.junit2.info.ClassBasedInfo;
import com.intellij.execution.junit2.info.DisplayTestInfoExtractor;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.execution.junit2.segments.ObjectReader;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;

class TestCaseInfo
extends ClassBasedInfo {
    private String myMethod;

    public TestCaseInfo() {
        super(DisplayTestInfoExtractor.CLASS_FULL_NAME);
    }

    @Override
    public void readFrom(ObjectReader reader) {
        this.myMethod = reader.readLimitedString();
        this.readClass(reader);
    }

    @Override
    public String getName() {
        return this.myMethod;
    }

    @Override
    public Location getLocation(Project project, GlobalSearchScope searchScope) {
        PsiMethod method;
        Location classLocation = super.getLocation(project, searchScope);
        if (classLocation == null) {
            return null;
        }
        String strippedMethodName = this.myMethod;
        int idx = this.myMethod.indexOf(91);
        if (idx != -1) {
            strippedMethodName = this.myMethod.substring(0, idx);
        }
        if ((method = MethodSignatureUtil.findMethodBySignature((PsiClass)((PsiClass)classLocation.getPsiElement()), (MethodSignature)MethodSignatureUtil.createMethodSignature((String)strippedMethodName, (PsiType[])PsiType.EMPTY_ARRAY, (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY), (boolean)true)) != null) {
            return new MethodLocation(project, method, classLocation);
        }
        return null;
    }

    @Override
    public boolean shouldRun() {
        return true;
    }
}

