/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.segments;

import com.intellij.execution.junit2.TestProxy;
import com.intellij.execution.junit2.info.TestInfo;
import com.intellij.execution.junit2.segments.ObjectReader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

public class InputObjectRegistry {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.junit2.segments.InputObjectRegistryImpl");
    private final Map<String, TestProxy> myKnownObjects = new HashMap();

    public TestProxy getByKey(String key) {
        TestProxy result = this.myKnownObjects.get(key);
        if (result == null) {
            LOG.error("Unknwon key: " + key);
            LOG.info("Known keys:");
            ArrayList<String> knownKeys = new ArrayList<String>(this.myKnownObjects.keySet());
            Collections.sort(knownKeys);
            LOG.info(knownKeys.toString());
        }
        return result;
    }

    public void readPacketFrom(ObjectReader reader) {
        String reference = reader.upTo(':');
        if (this.myKnownObjects.containsKey(reference)) {
            return;
        }
        TestProxy test = new TestProxy(TestInfo.readInfoFrom(reader));
        this.myKnownObjects.put(reference, test);
    }
}

