/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.ui;

import com.intellij.execution.junit2.ui.ConsolePanel;
import com.intellij.execution.junit2.ui.model.JUnitRunningModel;
import com.intellij.execution.junit2.ui.model.TreeCollapser;
import com.intellij.execution.junit2.ui.properties.JUnitConsoleProperties;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.testframework.ui.TestResultsPanel;
import javax.swing.JComponent;

public class JUnitTreeConsoleView
extends BaseTestsOutputConsoleView {
    private ConsolePanel myConsolePanel;
    private final JUnitConsoleProperties myProperties;
    private final ExecutionEnvironment myEnvironment;

    public JUnitTreeConsoleView(JUnitConsoleProperties properties, ExecutionEnvironment environment, AbstractTestProxy unboundOutputRoot) {
        super((TestConsoleProperties)properties, unboundOutputRoot);
        this.myProperties = properties;
        this.myEnvironment = environment;
    }

    protected TestResultsPanel createTestResultsPanel() {
        this.myConsolePanel = new ConsolePanel(this.getConsole().getComponent(), this.getPrinter(), this.myProperties, this.myEnvironment, this.getConsole().createConsoleActions());
        return this.myConsolePanel;
    }

    public void attachToProcess(ProcessHandler processHandler) {
        super.attachToProcess(processHandler);
        this.myConsolePanel.onProcessStarted(processHandler);
    }

    public void dispose() {
        super.dispose();
        this.myConsolePanel = null;
    }

    public JComponent getPreferredFocusableComponent() {
        return this.myConsolePanel.getTreeView();
    }

    public void attachToModel(JUnitRunningModel model) {
        if (this.myConsolePanel != null) {
            this.myConsolePanel.getTreeView().attachToModel((TestFrameworkRunningModel)model);
            model.attachToTree(this.myConsolePanel.getTreeView());
            this.myConsolePanel.setModel(model);
            model.onUIBuilt();
            new TreeCollapser().setModel(model);
        }
    }
}

