/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.ui.properties;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.testframework.JavaAwareTestConsoleProperties;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.config.Storage;
import org.jetbrains.annotations.NonNls;

public class JUnitConsoleProperties
extends JavaAwareTestConsoleProperties {
    @NonNls
    private static final String GROUP_NAME = "JUnitSupport.";
    private final JUnitConfiguration myConfiguration;

    public JUnitConsoleProperties(JUnitConfiguration configuration, Executor executor) {
        this(configuration, (Storage)new Storage.PropertiesComponentStorage(GROUP_NAME, PropertiesComponent.getInstance()), executor);
    }

    public JUnitConsoleProperties(JUnitConfiguration configuration, Storage storage, Executor executor) {
        super(storage, configuration.getProject(), executor);
        this.myConfiguration = configuration;
    }

    public JUnitConfiguration getConfiguration() {
        return this.myConfiguration;
    }

    protected GlobalSearchScope initScope() {
        JUnitConfiguration.Data persistentData = this.myConfiguration.getPersistentData();
        String testObject = persistentData.TEST_OBJECT;
        if ("category".equals(testObject) || "pattern".equals(testObject) || "package".equals(testObject)) {
            SourceScope sourceScope = persistentData.getScope().getSourceScope((ModuleBasedConfiguration)this.myConfiguration);
            return sourceScope != null ? sourceScope.getGlobalSearchScope() : GlobalSearchScope.allScope((Project)this.getProject());
        }
        return super.initScope();
    }
}

