/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.FileContentUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.InjectionsSettingsUI;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;

public class EditInjectionSettingsAction
implements IntentionAction,
LowPriorityAction {
    public static final String EDIT_INJECTION_TITLE = "Language Injection Settings";

    public String getText() {
        return EDIT_INJECTION_TITLE;
    }

    public String getFamilyName() {
        return "Edit Injection Settings";
    }

    public boolean isAvailable(Project project, Editor editor, PsiFile file) {
        int offset = editor.getCaretModel().getOffset();
        PsiFile psiFile = InjectedLanguageUtil.findInjectedPsiNoCommit((PsiFile)file, (int)offset);
        if (psiFile == null) {
            return false;
        }
        LanguageInjectionSupport support = (LanguageInjectionSupport)psiFile.getUserData(LanguageInjectionSupport.SETTINGS_EDITOR);
        return support != null;
    }

    public void invoke(final Project project, final Editor editor, final PsiFile file) throws IncorrectOperationException {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                EditInjectionSettingsAction.invokeImpl(project, editor, file);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void invokeImpl(Project project, Editor editor, PsiFile file) {
        PsiFile psiFile = InjectedLanguageUtil.findInjectedPsiNoCommit((PsiFile)file, (int)editor.getCaretModel().getOffset());
        if (psiFile == null) {
            return;
        }
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)project).getInjectionHost((PsiElement)psiFile);
        if (host == null) {
            return;
        }
        LanguageInjectionSupport support = (LanguageInjectionSupport)psiFile.getUserData(LanguageInjectionSupport.SETTINGS_EDITOR);
        if (support == null) {
            return;
        }
        try {
            if (!support.editInjectionInPlace(host)) {
                ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)new InjectionsSettingsUI(project, Configuration.getProjectInstance(project)));
            }
        }
        finally {
            FileContentUtil.reparseFiles((Project)project, Collections.emptyList(), (boolean)true);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }
}

