/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.highlighting.HighlightErrorFilter;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;

public class FrankensteinErrorFilter
extends HighlightErrorFilter
implements HighlightInfoFilter {
    public boolean shouldHighlightErrorElement(PsiErrorElement element) {
        return !FrankensteinErrorFilter.isFrankenstein(element.getContainingFile());
    }

    public boolean accept(HighlightInfo highlightInfo, PsiFile file) {
        if (highlightInfo.getSeverity() != HighlightSeverity.WARNING && highlightInfo.getSeverity() != HighlightSeverity.WEAK_WARNING) {
            return true;
        }
        if (file == null || !FrankensteinErrorFilter.isFrankenstein(file)) {
            return true;
        }
        int start = highlightInfo.getStartOffset();
        int end = highlightInfo.getEndOffset();
        String text = file.getText().substring(start, end);
        return !"missingValue".equals(text);
    }

    private static boolean isFrankenstein(PsiFile file) {
        return file != null && Boolean.TRUE.equals(file.getUserData(InjectedLanguageUtil.FRANKENSTEIN_INJECTION));
    }
}

