/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.config;

import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayFactory;

public class InjectionPlace {
    public static final InjectionPlace[] EMPTY_ARRAY = new InjectionPlace[0];
    public static final ArrayFactory<InjectionPlace> ARRAY_FACTORY = new ArrayFactory<InjectionPlace>(){

        public InjectionPlace[] create(int count) {
            return count == 0 ? EMPTY_ARRAY : new InjectionPlace[count];
        }
    };
    private final boolean myEnabled;
    private final ElementPattern<PsiElement> myElementPattern;

    public InjectionPlace(ElementPattern<PsiElement> myElementPattern, boolean enabled) {
        this.myElementPattern = myElementPattern;
        this.myEnabled = enabled;
    }

    public InjectionPlace enabled(boolean enabled) {
        return new InjectionPlace(this.myElementPattern, enabled);
    }

    public String getText() {
        return this.myElementPattern.toString();
    }

    public ElementPattern<PsiElement> getElementPattern() {
        return this.myElementPattern;
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InjectionPlace place = (InjectionPlace)o;
        return this.myElementPattern.equals(place.myElementPattern);
    }

    public int hashCode() {
        return this.myElementPattern.hashCode();
    }

    public String toString() {
        return "InjectionPlace{" + (this.myEnabled ? "+ " : "- ") + this.myElementPattern + '}';
    }
}

