/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.pattern;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.util.PsiUtilEx;
import org.intellij.plugins.intelliLang.util.RemoveAnnotationFix;
import org.jetbrains.annotations.NonNls;

public class PatternAnnotationNotApplicable
extends LocalInspectionTool {
    public HighlightDisplayLevel getDefaultLevel() {
        return HighlightDisplayLevel.ERROR;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public String getGroupDisplayName() {
        return "Pattern Validation";
    }

    public String getDisplayName() {
        return "Pattern Annotation not applicable";
    }

    public PsiElementVisitor buildVisitor(final ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){
            final String annotationName;
            {
                this.annotationName = Configuration.getProjectInstance(holder.getProject()).getAdvancedConfiguration().getPatternAnnotationClass();
            }

            public void visitAnnotation(PsiAnnotation annotation) {
                PsiClass psiClass;
                String name = annotation.getQualifiedName();
                if (this.annotationName.equals(name)) {
                    PatternAnnotationNotApplicable.this.checkAnnotation(annotation, holder);
                } else if (name != null && (psiClass = JavaPsiFacade.getInstance((Project)annotation.getProject()).findClass(name, annotation.getResolveScope())) != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)this.annotationName, (boolean)false, (boolean)false)) {
                    PatternAnnotationNotApplicable.this.checkAnnotation(annotation, holder);
                }
            }
        };
    }

    private void checkAnnotation(PsiAnnotation annotation, ProblemsHolder holder) {
        PsiType type;
        PsiModifierListOwner owner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiModifierListOwner.class);
        if (owner instanceof PsiVariable) {
            PsiType type2 = ((PsiVariable)owner).getType();
            if (!PsiUtilEx.isString(type2)) {
                this.registerProblem(annotation, holder);
            }
        } else if (owner instanceof PsiMethod && (type = ((PsiMethod)owner).getReturnType()) != null && !PsiUtilEx.isString(type)) {
            this.registerProblem(annotation, holder);
        }
    }

    private void registerProblem(PsiAnnotation annotation, ProblemsHolder holder) {
        holder.registerProblem((PsiElement)annotation, "Pattern Annotation is only applicable to elements of type String", new LocalQuickFix[]{new RemoveAnnotationFix(this)});
    }

    @NonNls
    public String getShortName() {
        return "PatternNotApplicable";
    }
}

