/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.pattern;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.JavaRefactoringActionHandlerFactory;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.util.AnnotateFix;
import org.intellij.plugins.intelliLang.util.AnnotationUtilEx;
import org.intellij.plugins.intelliLang.util.PsiUtilEx;
import org.intellij.plugins.intelliLang.util.SubstitutedExpressionEvaluationHelper;
import org.jetbrains.annotations.NonNls;

public class PatternValidator
extends LocalInspectionTool {
    private static final Key<CachedValue<Pattern>> COMPLIED_PATTERN = Key.create((String)"COMPILED_PATTERN");
    public static final String PATTERN_VALIDATION = "Pattern Validation";
    public static final String LANGUAGE_INJECTION = "Language Injection";
    public boolean CHECK_NON_CONSTANT_VALUES = true;
    private final Configuration myConfiguration = Configuration.getInstance();

    public boolean isEnabledByDefault() {
        return true;
    }

    public String getGroupDisplayName() {
        return PATTERN_VALIDATION;
    }

    public String getDisplayName() {
        return "Validate Annotated Patterns";
    }

    public JComponent createOptionsPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        final JCheckBox jCheckBox = new JCheckBox("Flag non compile-time constant expressions");
        jCheckBox.setToolTipText("If checked, the inspection will flag expressions with unknown values and offer to add a substitution (@Subst) annotation");
        jCheckBox.setSelected(this.CHECK_NON_CONSTANT_VALUES);
        jCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PatternValidator.this.CHECK_NON_CONSTANT_VALUES = jCheckBox.isSelected();
            }
        });
        jPanel.add((Component)jCheckBox, "North");
        return jPanel;
    }

    @NonNls
    public String getShortName() {
        return "PatternValidation";
    }

    public PsiElementVisitor buildVisitor(final ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public final void visitReferenceExpression(PsiReferenceExpression expression) {
                this.visitExpression((PsiExpression)expression);
            }

            public void visitExpression(PsiExpression expression) {
                PsiNameValuePair valuePair;
                String name;
                PsiElement element = expression.getParent();
                if (element instanceof PsiExpressionList) {
                    this.check(expression, holder, false);
                } else if (element instanceof PsiNameValuePair && ((name = (valuePair = (PsiNameValuePair)element).getName()) == null || name.equals("value"))) {
                    this.check(expression, holder, true);
                }
            }

            public void visitReturnStatement(PsiReturnStatement statement) {
                PsiExpression returnValue = statement.getReturnValue();
                if (returnValue != null) {
                    this.check(returnValue, holder, false);
                }
            }

            public void visitVariable(PsiVariable var) {
                PsiExpression initializer = var.getInitializer();
                if (initializer != null) {
                    this.check(initializer, holder, false);
                }
            }

            public void visitAssignmentExpression(PsiAssignmentExpression expression) {
                PsiExpression e = expression.getRExpression();
                if (e != null) {
                    this.check(e, holder, false);
                }
                this.visitExpression((PsiExpression)expression);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private void check(PsiExpression expression, ProblemsHolder holder2, boolean isAnnotationValue) {
                if (expression instanceof PsiConditionalExpression) {
                    PsiConditionalExpression expr = (PsiConditionalExpression)expression;
                    PsiExpression e = expr.getThenExpression();
                    if (e != null) {
                        this.check(e, holder2, isAnnotationValue);
                    }
                    if ((e = expr.getElseExpression()) == null) return;
                    this.check(e, holder2, isAnnotationValue);
                    return;
                } else {
                    PsiModifierListOwner element;
                    PsiType type = expression.getType();
                    if (type == null || !PsiUtilEx.isString(type)) return;
                    if (isAnnotationValue) {
                        PsiAnnotation psiAnnotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiAnnotation.class);
                        if (psiAnnotation == null || !PatternValidator.this.myConfiguration.getAdvancedConfiguration().getSubstAnnotationClass().equals(psiAnnotation.getQualifiedName())) return;
                        element = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiModifierListOwner.class);
                    } else {
                        element = AnnotationUtilEx.getAnnotatedElementFor((PsiElement)expression, AnnotationUtilEx.LookupType.PREFER_CONTEXT);
                    }
                    if (element == null || !PsiUtilEx.isLanguageAnnotationTarget(element)) return;
                    PsiAnnotation[] annotations = AnnotationUtilEx.getAnnotationFrom(element, PatternValidator.this.myConfiguration.getAdvancedConfiguration().getPatternAnnotationPair(), true);
                    PatternValidator.this.checkExpression(expression, annotations, holder2);
                }
            }
        };
    }

    private void checkExpression(PsiExpression expression, final PsiAnnotation[] annotations, ProblemsHolder holder) {
        String o;
        Pattern pattern;
        if (annotations.length == 0) {
            return;
        }
        final PsiAnnotation psiAnnotation = annotations[0];
        CachedValue p = (CachedValue)psiAnnotation.getUserData(COMPLIED_PATTERN);
        if (p == null) {
            CachedValueProvider<Pattern> provider = new CachedValueProvider<Pattern>(){

                public CachedValueProvider.Result<Pattern> compute() {
                    String pattern = AnnotationUtilEx.calcAnnotationValue(psiAnnotation, "value");
                    Pattern p = null;
                    if (pattern != null) {
                        try {
                            p = Pattern.compile(pattern);
                        }
                        catch (PatternSyntaxException patternSyntaxException) {
                            // empty catch block
                        }
                    }
                    return CachedValueProvider.Result.create((Object)p, (Object[])annotations);
                }
            };
            p = CachedValuesManager.getManager((Project)expression.getProject()).createCachedValue((CachedValueProvider)provider, false);
            psiAnnotation.putUserData(COMPLIED_PATTERN, (Object)p);
        }
        if ((pattern = (Pattern)p.getValue()) == null) {
            return;
        }
        SmartList nonConstantElements = new SmartList();
        Object result = new SubstitutedExpressionEvaluationHelper(expression.getProject()).computeExpression(expression, this.myConfiguration.getAdvancedConfiguration().getDfaOption(), false, (List<PsiExpression>)nonConstantElements);
        String string = o = result == null ? null : String.valueOf(result);
        if (o != null) {
            if (!pattern.matcher(o).matches()) {
                if (annotations.length > 1) {
                    String fqn = annotations[annotations.length - 1].getQualifiedName();
                    assert (fqn != null);
                    String name = StringUtil.getShortName((String)fqn);
                    holder.registerProblem((PsiElement)expression, MessageFormat.format("Expression ''{0}'' doesn''t match ''{1}'' pattern: {2}", o, name, pattern.pattern()), new LocalQuickFix[0]);
                } else {
                    holder.registerProblem((PsiElement)expression, MessageFormat.format("Expression ''{0}'' doesn''t match pattern: {1}", o, pattern.pattern()), new LocalQuickFix[0]);
                }
            }
        } else if (this.CHECK_NON_CONSTANT_VALUES) {
            for (PsiExpression expr : nonConstantElements) {
                Object quickFix;
                PsiModifierListOwner owner;
                Object e = expr instanceof PsiReferenceExpression ? ((PsiReferenceExpression)expr).resolve() : (expr instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)expr).getMethodExpression().resolve() : expr);
                PsiModifierListOwner psiModifierListOwner = owner = e instanceof PsiModifierListOwner ? (PsiModifierListOwner)e : null;
                if (owner != null && PsiUtilEx.isLanguageAnnotationTarget(owner)) {
                    PsiAnnotation[] resolvedAnnos = AnnotationUtilEx.getAnnotationFrom(owner, this.myConfiguration.getAdvancedConfiguration().getPatternAnnotationPair(), true);
                    if (resolvedAnnos.length == 2 && annotations.length == 2 && Comparing.strEqual((String)resolvedAnnos[1].getQualifiedName(), (String)annotations[1].getQualifiedName())) {
                        return;
                    }
                    String classname = (String)this.myConfiguration.getAdvancedConfiguration().getSubstAnnotationPair().first;
                    AnnotateFix fix = new AnnotateFix((PsiModifierListOwner)e, classname);
                    quickFix = fix.canApply() ? fix : new IntroduceVariableFix(expr);
                } else {
                    quickFix = new IntroduceVariableFix(expr);
                }
                holder.registerProblem((PsiElement)expr, "Unsubstituted expression", new LocalQuickFix[]{quickFix});
            }
        }
    }

    private static class IntroduceVariableFix
    implements LocalQuickFix {
        private final PsiExpression myExpr;

        public IntroduceVariableFix(PsiExpression expr) {
            this.myExpr = expr;
        }

        public String getName() {
            return "Introduce Variable";
        }

        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(final Project project, ProblemDescriptor descriptor) {
            final RefactoringActionHandler handler = JavaRefactoringActionHandlerFactory.getInstance().createIntroduceVariableHandler();
            AsyncResult dataContextContainer = DataManager.getInstance().getDataContextFromFocus();
            dataContextContainer.doWhenDone((Consumer)new Consumer<DataContext>(){

                public void consume(DataContext dataContext) {
                    handler.invoke(project, new PsiElement[]{IntroduceVariableFix.this.myExpr}, dataContext);
                }
            });
        }
    }
}

