/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.util;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import org.intellij.plugins.intelliLang.util.InitializerRequirement;
import org.intellij.plugins.intelliLang.util.PsiUtilEx;

public class AnnotateFix
implements LocalQuickFix {
    private final PsiModifierListOwner myElement;
    private final String myAnnotationName;
    private final String myArgList;

    public AnnotateFix(PsiModifierListOwner owner, String annotationClassname) {
        this(owner, annotationClassname, null);
    }

    public AnnotateFix(PsiModifierListOwner owner, String annotationClassname, String argList) {
        this.myElement = owner;
        this.myAnnotationName = annotationClassname;
        this.myArgList = argList;
    }

    public String getName() {
        return "Annotate with @" + StringUtil.getShortName((String)this.myAnnotationName);
    }

    public String getFamilyName() {
        return this.getName();
    }

    public boolean canApply() {
        return PsiUtilEx.isInSourceContent((PsiElement)this.myElement) && this.myElement.getModifierList() != null;
    }

    public void applyFix(Project project, ProblemDescriptor descriptor) {
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)this.myElement)) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        try {
            String argList;
            PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(this.myAnnotationName, this.myElement.getResolveScope());
            InitializerRequirement requirement = InitializerRequirement.calcInitializerRequirement(psiClass);
            if (this.myArgList == null) {
                switch (requirement) {
                    case VALUE_REQUIRED: 
                    case OTHER_REQUIRED: {
                        argList = "(\"\")";
                        break;
                    }
                    default: {
                        argList = "";
                        break;
                    }
                }
            } else {
                argList = this.myArgList;
            }
            PsiAnnotation annotation = factory.createAnnotationFromText("@" + this.myAnnotationName + argList, (PsiElement)this.myElement);
            PsiModifierList modifierList = this.myElement.getModifierList();
            if (modifierList != null) {
                annotation = (PsiAnnotation)modifierList.addBefore((PsiElement)annotation, modifierList.getFirstChild());
                annotation = (PsiAnnotation)JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)annotation);
                PsiAnnotationParameterList list = annotation.getParameterList();
                if (requirement != InitializerRequirement.NONE_REQUIRED && this.myArgList == null) {
                    ((NavigationItem)list).navigate(true);
                }
            }
        }
        catch (IncorrectOperationException e) {
            Logger.getInstance((String)this.getClass().getName()).error((Throwable)e);
        }
    }
}

