/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.util;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import java.util.HashSet;
import java.util.Set;
import org.intellij.lang.regexp.RegExpFileType;
import org.intellij.lang.regexp.psi.RegExpAtom;
import org.intellij.lang.regexp.psi.RegExpBranch;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpPattern;

public class RegExpUtil {
    private RegExpUtil() {
    }

    public static Set<String> getEnumValues(Project project, String regExp) {
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)project);
        PsiFile file = factory.createFileFromText("dummy.regexp", (FileType)RegExpFileType.INSTANCE, (CharSequence)regExp);
        RegExpPattern pattern = (RegExpPattern)file.getFirstChild();
        if (pattern == null) {
            return null;
        }
        RegExpBranch[] branches = pattern.getBranches();
        HashSet<String> values = new HashSet<String>();
        for (RegExpBranch branch : branches) {
            if (!RegExpUtil.analyzeBranch(branch)) continue;
            values.add(branch.getUnescapedText());
        }
        return values;
    }

    private static boolean analyzeBranch(RegExpBranch branch) {
        RegExpAtom[] atoms;
        for (RegExpAtom atom : atoms = branch.getAtoms()) {
            if (!(atom instanceof RegExpChar) || ((RegExpChar)atom).getValue() == null) {
                return false;
            }
            if (((RegExpChar)atom).getType() == RegExpChar.Type.CHAR) continue;
            return false;
        }
        return true;
    }
}

