/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.blame.parser.aapt;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.blame.SourceFragmentPositionRange;
import com.android.ide.common.blame.output.GradleMessage;
import com.android.ide.common.blame.parser.ParsingFailedException;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.aapt.ReadOnlyDocument;
import com.android.ide.common.blame.parser.util.OutputLineReader;
import com.android.utils.ILogger;
import com.android.utils.SdkUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractAaptOutputParser
implements PatternAwareOutputParser {
    private static final Pattern PROPERTY_NAME_AND_VALUE = Pattern.compile("\\(at '(.+)' with value '(.*)'\\)");
    private static final Pattern REPEATED_RESOURCE = Pattern.compile("Resource entry (.+) already has bag item (.+)\\.");
    private static final String ORIGINALLY_DEFINED_HERE = "Originally defined here.";
    private static final Pattern NO_RESOURCE_FOUND = Pattern.compile("No resource found that matches the given name: attr '(.+)'\\.");
    private static final Pattern REQUIRED_ATTRIBUTE = Pattern.compile("A '(.+)' attribute is required for <(.+)>");
    private static final String START_MARKER = "<!-- From: ";
    private static final String END_MARKER = " -->";
    private static final Cache<String, ReadOnlyDocument> ourDocumentsByPathCache = CacheBuilder.newBuilder().weakValues().build();
    public static File ourRootDir;

    @NonNull
    private static SourceFragmentPositionRange findMessagePositionInFile(@NonNull File file, @NonNull String msgText, int locationLine, ILogger logger) {
        SourceFragmentPositionRange exactPosition = AbstractAaptOutputParser.findExactMessagePositionInFile(file, msgText, locationLine, logger);
        if (exactPosition != null) {
            return exactPosition;
        }
        return new SourceFragmentPositionRange(locationLine, -1, -1);
    }

    @Nullable
    private static SourceFragmentPositionRange findExactMessagePositionInFile(@NonNull File file, @NonNull String msgText, int locationLine, @NonNull ILogger logger) {
        Matcher matcher = PROPERTY_NAME_AND_VALUE.matcher(msgText);
        if (matcher.find()) {
            String name = matcher.group(1);
            String value = matcher.group(2);
            if (!value.isEmpty()) {
                return AbstractAaptOutputParser.findText(file, name, value, locationLine, logger);
            }
            SourceFragmentPositionRange position1 = AbstractAaptOutputParser.findText(file, name, "\"\"", locationLine, logger);
            SourceFragmentPositionRange position2 = AbstractAaptOutputParser.findText(file, name, "''", locationLine, logger);
            if (position1 == null) {
                if (position2 == null) {
                    return AbstractAaptOutputParser.findText(file, name, null, locationLine, logger);
                }
                return position2;
            }
            if (position2 == null) {
                return position1;
            }
            if (position1.getStartOffset() < position2.getStartOffset()) {
                return position1;
            }
            return position2;
        }
        matcher = REPEATED_RESOURCE.matcher(msgText);
        if (matcher.find()) {
            String property = matcher.group(2);
            return AbstractAaptOutputParser.findText(file, property, null, locationLine, logger);
        }
        matcher = NO_RESOURCE_FOUND.matcher(msgText);
        if (matcher.find()) {
            String property = matcher.group(1);
            return AbstractAaptOutputParser.findText(file, property, null, locationLine, logger);
        }
        matcher = REQUIRED_ATTRIBUTE.matcher(msgText);
        if (matcher.find()) {
            String elementName = matcher.group(2);
            return AbstractAaptOutputParser.findText(file, '<' + elementName, null, locationLine, logger);
        }
        if (msgText.endsWith(ORIGINALLY_DEFINED_HERE)) {
            return AbstractAaptOutputParser.findLineStart(file, locationLine, logger);
        }
        return null;
    }

    @Nullable
    private static SourceFragmentPositionRange findText(@NonNull File file, @NonNull String first, @Nullable String second, int locationLine, @NonNull ILogger logger) {
        ReadOnlyDocument document = AbstractAaptOutputParser.getDocument(file, logger);
        if (document == null) {
            return null;
        }
        int offset = document.lineOffset(locationLine);
        if ((long)offset == -1L) {
            return null;
        }
        int resultOffset = document.findText(first, offset);
        if ((long)resultOffset == -1L) {
            return null;
        }
        if (second != null && (long)(resultOffset = document.findText(second, resultOffset + first.length())) == -1L) {
            return null;
        }
        int startLineNumber = document.lineNumber(resultOffset);
        int startLineOffset = document.lineOffset(startLineNumber);
        int endResultOffset = resultOffset + (second != null ? second.length() : first.length());
        int endLineNumber = document.lineNumber(endResultOffset);
        int endLineOffset = document.lineOffset(endLineNumber);
        return new SourceFragmentPositionRange(startLineNumber, resultOffset - startLineOffset + 1, resultOffset, endLineNumber, endResultOffset - endLineOffset + 1, endResultOffset);
    }

    @Nullable
    private static SourceFragmentPositionRange findLineStart(@NonNull File file, int locationLine, ILogger logger) {
        ReadOnlyDocument document = AbstractAaptOutputParser.getDocument(file, logger);
        if (document == null) {
            return null;
        }
        int lineOffset = document.lineOffset(locationLine);
        if ((long)lineOffset == -1L) {
            return null;
        }
        int nextLineOffset = document.lineOffset(locationLine + 1);
        if (nextLineOffset == -1) {
            nextLineOffset = document.length();
        }
        int resultOffset = -1;
        for (int i = lineOffset; i < nextLineOffset; ++i) {
            char c = document.charAt(i);
            if (Character.isWhitespace(c)) continue;
            resultOffset = i;
            break;
        }
        if ((long)resultOffset == -1L) {
            return null;
        }
        int endResultOffset = resultOffset;
        for (int i = nextLineOffset - 1; i >= resultOffset; --i) {
            char c = document.charAt(i);
            if (Character.isWhitespace(c)) continue;
            endResultOffset = i;
            break;
        }
        return new SourceFragmentPositionRange(locationLine, resultOffset - lineOffset + 1, resultOffset, locationLine, endResultOffset - lineOffset + 1, endResultOffset);
    }

    @Nullable
    private static ReadOnlyDocument getDocument(@NonNull File file, ILogger logger) {
        String filePath = file.getAbsolutePath();
        ReadOnlyDocument document = (ReadOnlyDocument)ourDocumentsByPathCache.getIfPresent((Object)filePath);
        if (document == null || document.isStale()) {
            try {
                if (!file.exists()) {
                    if (ourRootDir != null && ourRootDir.isAbsolute() && !file.isAbsolute()) {
                        file = new File(ourRootDir, file.getPath());
                        return AbstractAaptOutputParser.getDocument(file, logger);
                    }
                    return null;
                }
                document = new ReadOnlyDocument(file);
                ourDocumentsByPathCache.put((Object)filePath, (Object)document);
            }
            catch (IOException e) {
                String format = "Unexpected error occurred while reading file '%s' [%s]";
                logger.warning(format, new Object[]{file.getAbsolutePath(), e});
                return null;
            }
        }
        return document;
    }

    @NonNull
    private static String urlToPath(@NonNull String url) {
        if (url.startsWith("file:")) {
            String prefix = url.startsWith("file://") ? "file://" : "file:";
            return url.substring(prefix.length());
        }
        return url;
    }

    public static int findResourceLine(@NonNull File file, @NonNull String key, @NonNull ILogger logger) {
        int slash = key.indexOf(47);
        if (slash == -1) {
            assert (false) : slash;
            return -1;
        }
        String type = key.substring(0, slash);
        String name = key.substring(slash + 1);
        return AbstractAaptOutputParser.findValueDeclaration(file, type, name, logger);
    }

    public static int findValueDeclaration(@NonNull File file, @NonNull String type, @NonNull String name, @NonNull ILogger logger) {
        if (!file.exists()) {
            return -1;
        }
        ReadOnlyDocument document = AbstractAaptOutputParser.getDocument(file, logger);
        if (document == null) {
            return -1;
        }
        int index = document.findText(name, 0);
        if (index == -1) {
            return -1;
        }
        if (document.findText(name, index + name.length()) == -1) {
            return document.lineNumber(index);
        }
        int nameIndex = document.findText("name=\"" + name + "\"", 0);
        if (nameIndex != -1) {
            return document.lineNumber(nameIndex);
        }
        int lineNumber = AbstractAaptOutputParser.findValueDeclarationViaParse(type, name, document);
        if (lineNumber != -1) {
            return lineNumber;
        }
        assert (index != -1);
        return document.lineNumber(index);
    }

    private static int findValueDeclarationViaParse(final String type, final String name, ReadOnlyDocument document) {
        int column;
        int lineNumber;
        final int[] certain = new int[]{-1, 0};
        final int[] possible = new int[]{-1, 0};
        final AtomicReference<Integer> line = new AtomicReference<Integer>(-1);
        DefaultHandler handler = new DefaultHandler(){
            private int myDepth;
            private Locator myLocator;

            @Override
            public void setDocumentLocator(Locator locator) {
                this.myLocator = locator;
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                ++this.myDepth;
                if (this.myDepth == 2 && name.equals(attributes.getValue("name"))) {
                    int lineNumber = this.myLocator.getLineNumber();
                    int column = this.myLocator.getColumnNumber();
                    if (qName.equals(type) || "item".equals(qName) && type.equals(attributes.getValue("type"))) {
                        line.set(lineNumber);
                        certain[0] = lineNumber;
                        certain[1] = column;
                    } else if ((Integer)line.get() < 0) {
                        line.set(-lineNumber);
                        possible[0] = lineNumber;
                        possible[1] = column;
                    }
                }
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                --this.myDepth;
            }
        };
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(new InputSource(new StringReader(document.getContents())), handler);
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (certain[0] != -1) {
            lineNumber = certain[0];
            column = certain[1];
        } else {
            lineNumber = possible[0];
            column = possible[1];
        }
        if (lineNumber != -1) {
            int offset = document.lineOffset(lineNumber) + column;
            if ((offset = document.findTextBackwards(name, offset)) != -1) {
                lineNumber = document.lineNumber(offset);
            }
            return lineNumber;
        }
        return -1;
    }

    @Nullable
    final Matcher getNextLineMatcher(@NonNull OutputLineReader reader, @NonNull Pattern pattern) {
        String line = reader.readLine();
        if (line == null) {
            return null;
        }
        Matcher m = pattern.matcher(line);
        return m.matches() ? m : null;
    }

    @NonNull
    GradleMessage createMessage(@NonNull GradleMessage.Kind kind, @NonNull String text, @Nullable String sourcePath, @Nullable String lineNumberAsText, @NonNull String original, ILogger logger) throws ParsingFailedException {
        FilePosition source;
        File file = null;
        if (sourcePath != null && !(file = new File(sourcePath)).isFile()) {
            throw new ParsingFailedException();
        }
        SourceFragmentPositionRange errorPosition = this.parseLineNumber(lineNumberAsText);
        if (sourcePath != null && (source = AbstractAaptOutputParser.findSourcePosition(file, errorPosition.getStartLine(), text, logger)) != null) {
            file = source.sourceFile;
            sourcePath = file.getPath();
            if (source.position.getStartLine() != -1) {
                errorPosition = source.position;
            }
        }
        if (file != null && errorPosition.getStartLine() != -1) {
            errorPosition = AbstractAaptOutputParser.findMessagePositionInFile(file, text, errorPosition.getStartLine(), logger);
        }
        return new GradleMessage(kind, text, sourcePath, errorPosition, original);
    }

    private SourceFragmentPositionRange parseLineNumber(String lineNumberAsText) throws ParsingFailedException {
        int lineNumber = -1;
        if (lineNumberAsText != null) {
            try {
                lineNumber = Integer.parseInt(lineNumberAsText);
            }
            catch (NumberFormatException e) {
                throw new ParsingFailedException();
            }
        }
        return new SourceFragmentPositionRange(lineNumber, -1, -1);
    }

    @Nullable
    protected static FilePosition findSourcePosition(@NonNull File file, int locationLine, String message, ILogger logger) {
        SourceFragmentPositionRange position;
        File sourceFile;
        if (!file.getPath().endsWith(".xml")) {
            return null;
        }
        ReadOnlyDocument document = AbstractAaptOutputParser.getDocument(file, logger);
        if (document == null) {
            return null;
        }
        String fileName = file.getName();
        boolean isManifest = fileName.equals("AndroidManifest.xml");
        boolean isValueFile = fileName.equals("values.xml");
        int searchStart = isValueFile || isManifest ? document.lineOffset(locationLine) : document.length();
        if ((long)searchStart == -1L) {
            return null;
        }
        int start = document.findTextBackwards(START_MARKER, searchStart);
        assert (start < searchStart);
        if (start == -1 && isManifest && searchStart < document.length() && (long)(searchStart = document.length()) != -1L) {
            start = document.findTextBackwards(START_MARKER, searchStart);
            assert (start < searchStart);
        }
        if (start == -1) {
            return null;
        }
        int end = document.findText(END_MARKER, start += START_MARKER.length());
        if (end == -1) {
            return null;
        }
        String sourcePath = document.subsequence(start, end);
        if (sourcePath.startsWith("file:")) {
            String originalPath = sourcePath;
            sourceFile = new File(sourcePath = AbstractAaptOutputParser.urlToPath(sourcePath));
            if (!sourceFile.exists()) {
                try {
                    sourceFile = SdkUtils.urlToFile((String)originalPath);
                }
                catch (MalformedURLException e) {
                    logger.warning("Invalid file URL: " + originalPath, new Object[0]);
                }
            }
        } else {
            sourceFile = new File(sourcePath);
        }
        if (isValueFile && (position = AbstractAaptOutputParser.findMessagePositionInFile(sourceFile, message, 1, logger)) != null) {
            return new FilePosition(sourceFile, position);
        }
        return new FilePosition(sourceFile, new SourceFragmentPositionRange());
    }

    private static class FilePosition {
        final File sourceFile;
        final SourceFragmentPositionRange position;

        FilePosition(File sourceFile, SourceFragmentPositionRange position) {
            this.sourceFile = sourceFile;
            this.position = position;
        }
    }
}

