/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.jira;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.Comment;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskState;
import com.intellij.tasks.TaskType;
import com.intellij.tasks.jira.CachedIconLoader;
import icons.TasksIcons;
import java.util.Date;
import javax.swing.Icon;

public abstract class JiraTask
extends Task {
    protected final TaskRepository myRepository;

    protected JiraTask(TaskRepository repository) {
        this.myRepository = repository;
    }

    public abstract String getId();

    public abstract String getSummary();

    public abstract String getDescription();

    public abstract Comment[] getComments();

    protected abstract String getIconUrl();

    public abstract TaskType getType();

    public abstract TaskState getState();

    public abstract Date getUpdated();

    public abstract Date getCreated();

    public final String getIssueUrl() {
        return this.myRepository.getUrl() + "/browse/" + this.getId();
    }

    public final Icon getIcon() {
        return this.getIconByUrl(this.getIconUrl());
    }

    public final TaskRepository getRepository() {
        return this.myRepository;
    }

    public final boolean isClosed() {
        return this.getState() == TaskState.RESOLVED;
    }

    public final boolean isIssue() {
        return true;
    }

    protected final Icon getIconByUrl(String iconUrl) {
        if (StringUtil.isEmpty((String)iconUrl)) {
            return TasksIcons.Jira;
        }
        Icon icon = this.isClosed() ? CachedIconLoader.getDisabledIcon(iconUrl) : CachedIconLoader.getIcon(iconUrl);
        return icon != null ? icon : TasksIcons.Other;
    }

    protected final TaskState getStateById(int id) {
        switch (id) {
            case 1: {
                return TaskState.OPEN;
            }
            case 3: {
                return TaskState.IN_PROGRESS;
            }
            case 4: {
                return TaskState.REOPENED;
            }
            case 5: 
            case 6: {
                return TaskState.RESOLVED;
            }
        }
        return null;
    }

    protected final TaskType getTypeByName(String type) {
        if (type == null) {
            return TaskType.OTHER;
        }
        if ("Bug".equals(type)) {
            return TaskType.BUG;
        }
        if ("Exception".equals(type)) {
            return TaskType.EXCEPTION;
        }
        if ("New Feature".equals(type)) {
            return TaskType.FEATURE;
        }
        return TaskType.OTHER;
    }
}

