/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.jira.jql;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.tasks.jira.jql.JqlElementTypes;
import com.intellij.tasks.jira.jql.JqlFile;
import com.intellij.tasks.jira.jql.JqlLexer;
import com.intellij.tasks.jira.jql.JqlParser;
import com.intellij.tasks.jira.jql.JqlTokenTypes;

public class JqlParserDefinition
implements ParserDefinition {
    private static final Logger LOG = Logger.getInstance(JqlParserDefinition.class);

    public Lexer createLexer(Project project) {
        return new JqlLexer();
    }

    public PsiParser createParser(Project project) {
        return new JqlParser();
    }

    public IFileElementType getFileNodeType() {
        return JqlElementTypes.FILE;
    }

    public TokenSet getWhitespaceTokens() {
        return JqlTokenTypes.WHITESPACES;
    }

    public TokenSet getCommentTokens() {
        return TokenSet.EMPTY;
    }

    public TokenSet getStringLiteralElements() {
        return TokenSet.create((IElementType[])new IElementType[]{JqlTokenTypes.STRING_LITERAL});
    }

    public PsiElement createElement(ASTNode node) {
        return JqlElementTypes.Factory.createElement(node);
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new JqlFile(viewProvider);
    }

    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return ParserDefinition.SpaceRequirements.MAY;
    }
}

