/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.jira.jql.psi;

import com.intellij.psi.tree.IElementType;
import com.intellij.tasks.jira.jql.JqlTokenTypes;
import com.intellij.tasks.jira.jql.psi.JqlClause;
import com.intellij.tasks.jira.jql.psi.JqlIdentifier;
import java.util.IdentityHashMap;

public interface JqlTerminalClause
extends JqlClause {
    public Type getType();

    public JqlIdentifier getField();

    public String getFieldName();

    public static enum Type {
        EQ(false),
        NE(false),
        LT(false),
        GT(false),
        LE(false),
        GE(false),
        CONTAINS(false),
        NOT_CONTAINS(false),
        IS(false),
        IS_NOT(false),
        IN(true),
        NOT_IN(true),
        WAS(false),
        WAS_IN(true),
        WAS_NOT(false),
        WAS_NOT_IN(true),
        CHANGED(false);

        private boolean myListOperator;
        private static final IdentityHashMap<IElementType, Type> MAP;

        private Type(boolean listOperator) {
            this.myListOperator = listOperator;
        }

        public static Type fromTokenType(IElementType type) {
            return MAP.get(type);
        }

        public boolean isListOperator() {
            return this.myListOperator;
        }

        static {
            MAP = new IdentityHashMap();
            MAP.put(JqlTokenTypes.EQ, EQ);
            MAP.put(JqlTokenTypes.NE, NE);
            MAP.put(JqlTokenTypes.LT, LT);
            MAP.put(JqlTokenTypes.GT, GT);
            MAP.put(JqlTokenTypes.LE, LE);
            MAP.put(JqlTokenTypes.GE, GE);
            MAP.put(JqlTokenTypes.CONTAINS, CONTAINS);
            MAP.put(JqlTokenTypes.NOT_CONTAINS, NOT_CONTAINS);
        }
    }
}

