/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.jira.rest.api2;

import com.google.gson.reflect.TypeToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.CustomTaskState;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.jira.JiraRemoteApi;
import com.intellij.tasks.jira.JiraRepository;
import com.intellij.tasks.jira.rest.JiraRestApi;
import com.intellij.tasks.jira.rest.api2.model.JiraIssueApi2;
import com.intellij.tasks.jira.rest.api2.model.JiraTransitionsWrapperApi2;
import com.intellij.tasks.jira.rest.model.JiraIssue;
import com.intellij.tasks.jira.rest.model.JiraResponseWrapper;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;

public class JiraRestApi2
extends JiraRestApi {
    private static final Logger LOG = Logger.getInstance(JiraIssueApi2.class);
    private static final Type ISSUES_WRAPPER_TYPE = new TypeToken<JiraResponseWrapper.Issues<JiraIssueApi2>>(){}.getType();

    public JiraRestApi2(JiraRepository repository) {
        super(repository);
    }

    @Override
    protected GetMethod getMultipleIssuesSearchMethod(String jql, int max) {
        GetMethod method = super.getMultipleIssuesSearchMethod(jql, max);
        method.setQueryString(method.getQueryString() + "&fields=" + "id,key,summary,description,created,updated,duedate,resolutiondate,assignee,reporter,issuetype,comment,status");
        return method;
    }

    @Override
    protected List<JiraIssue> parseIssues(String response) {
        JiraResponseWrapper.Issues wrapper = (JiraResponseWrapper.Issues)JiraRepository.GSON.fromJson(response, ISSUES_WRAPPER_TYPE);
        return new ArrayList<JiraIssue>(wrapper.getIssues());
    }

    @Override
    protected GetMethod getSingleIssueSearchMethod(String key) {
        GetMethod method = super.getSingleIssueSearchMethod(key);
        String oldParams = method.getQueryString() == null ? "" : method.getQueryString();
        method.setQueryString(oldParams + "&fields=" + "id,key,summary,description,created,updated,duedate,resolutiondate,assignee,reporter,issuetype,comment,status");
        return method;
    }

    @Override
    protected JiraIssue parseIssue(String response) {
        return (JiraIssue)JiraRepository.GSON.fromJson(response, JiraIssueApi2.class);
    }

    @Override
    protected String getRequestForStateTransition(CustomTaskState state) {
        assert (StringUtil.isNotEmpty((String)state.getId()));
        String stateId = state.getId();
        int index = stateId.indexOf(58);
        if (index >= 0) {
            return "{  \"transition\": {\"id\": \"" + stateId.substring(0, index) + "\"}, " + "  \"fields\": {\"resolution\": {\"name\": \"" + stateId.substring(index + 1) + "\"}}" + "}";
        }
        return "{\"transition\": {\"id\": \"" + stateId + "\"}}";
    }

    @Override
    public Set<CustomTaskState> getAvailableTaskStates(Task task) throws Exception {
        GetMethod method = new GetMethod(this.myRepository.getRestUrl("issue", task.getId(), "transitions"));
        method.setQueryString("expand=transitions.fields");
        String response = this.myRepository.executeMethod((HttpMethod)method);
        JiraTransitionsWrapperApi2 wrapper = (JiraTransitionsWrapperApi2)JiraRepository.GSON.fromJson(response, JiraTransitionsWrapperApi2.class);
        return wrapper.getTransitions();
    }

    @Override
    public void updateTimeSpend(LocalTask task, String timeSpent, String comment) throws Exception {
        LOG.debug(String.format("Time spend: %s, comment: %s", timeSpent, comment));
        PostMethod method = new PostMethod(this.myRepository.getRestUrl("issue", task.getId(), "worklog"));
        String request = StringUtil.isEmpty((String)comment) ? String.format("{\"timeSpent\" : \"" + timeSpent + "\"}", timeSpent) : String.format("{\"timeSpent\": \"%s\", \"comment\": \"%s\"}", timeSpent, StringUtil.escapeQuotes((String)comment));
        method.setRequestEntity(JiraRestApi2.createJsonEntity(request));
        this.myRepository.executeMethod((HttpMethod)method);
    }

    @Override
    public JiraRemoteApi.ApiType getType() {
        return JiraRemoteApi.ApiType.REST_2_0;
    }
}

