/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.jira.rest.api2.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.tasks.CustomTaskState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JiraTransitionsWrapperApi2 {
    private static final Logger LOG = Logger.getInstance(JiraTransitionsWrapperApi2.class);
    private List<JiraTransition> transitions = Collections.emptyList();

    public Set<CustomTaskState> getTransitions() {
        LinkedHashSet<CustomTaskState> result = new LinkedHashSet<CustomTaskState>();
        block0: for (JiraTransition transition : this.transitions) {
            String stateName = transition.target.name;
            ArrayList<String> resolutions = new ArrayList<String>();
            if (transition.fields != null) {
                for (Map.Entry field : transition.fields.entrySet()) {
                    String fieldName = (String)field.getKey();
                    JsonObject fieldInfo = ((JsonElement)field.getValue()).getAsJsonObject();
                    if (!fieldInfo.get("required").getAsBoolean()) continue;
                    if (fieldName.equals("resolution")) {
                        for (JsonElement allowedValue : fieldInfo.getAsJsonArray("allowedValues")) {
                            resolutions.add(allowedValue.getAsJsonObject().get("name").getAsString());
                        }
                        continue;
                    }
                    LOG.info("Unknown required field '" + fieldName + "' for transition '" + stateName + "'");
                    continue block0;
                }
            }
            if (resolutions.isEmpty()) {
                result.add(new CustomTaskState(String.valueOf(transition.id), stateName));
                continue;
            }
            for (String resolution : resolutions) {
                result.add(new CustomTaskState(transition.id + ":" + resolution, stateName + " (" + resolution + ")"));
            }
        }
        return result;
    }

    static class JiraTransition {
        private int id;
        private String name;
        @SerializedName(value="to")
        private JiraTaskState target;
        private JsonObject fields;

        JiraTransition() {
        }

        static class JiraTaskState {
            private int id;
            private String name;

            JiraTaskState() {
            }
        }
    }
}

