/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.jira.soap;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.Comment;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskState;
import com.intellij.tasks.TaskType;
import com.intellij.tasks.jira.JiraTask;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.jdom.Element;

class JiraSoapTask
extends JiraTask {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.US);
    private final String myKey;
    private final String mySummary;
    private final String myDescription;
    private final String myIconUrl;
    private final Date myUpdated;
    private final Date myCreated;
    private final TaskState myState;
    private final TaskType myType;
    private final List<Comment> myComments;

    public JiraSoapTask(Element element, TaskRepository repository) {
        super(repository);
        this.myKey = element.getChildText("key");
        this.mySummary = element.getChildText("summary");
        this.myDescription = element.getChildText("description");
        this.myIconUrl = JiraSoapTask.getChildAttribute(element, "type", "iconUrl");
        this.myType = this.getTypeByName(element.getChildText("type"));
        String statusIdText = JiraSoapTask.getChildAttribute(element, "status", "id");
        this.myState = this.getStateById(StringUtil.isEmpty((String)statusIdText) ? 0 : Integer.parseInt(statusIdText));
        this.myCreated = JiraSoapTask.parseDate(element.getChildText("created"));
        this.myUpdated = JiraSoapTask.parseDate(element.getChildText("updated"));
        Element comments = element.getChild("comments");
        this.myComments = comments != null ? ContainerUtil.map((Collection)comments.getChildren("comment"), (Function)new Function<Element, Comment>(){

            public Comment fun(final Element element) {
                return new Comment(){

                    public String getText() {
                        return element.getText();
                    }

                    public String getAuthor() {
                        return element.getAttributeValue("author");
                    }

                    public Date getDate() {
                        return JiraSoapTask.parseDate(element.getAttributeValue("created"));
                    }
                };
            }
        }) : ContainerUtil.emptyList();
    }

    @Override
    public String getId() {
        return this.myKey;
    }

    @Override
    public String getSummary() {
        return this.mySummary;
    }

    @Override
    public String getDescription() {
        return this.myDescription;
    }

    @Override
    public Comment[] getComments() {
        return this.myComments.toArray(new Comment[this.myComments.size()]);
    }

    @Override
    protected String getIconUrl() {
        return this.myIconUrl;
    }

    @Override
    public TaskType getType() {
        return this.myType;
    }

    @Override
    public TaskState getState() {
        return this.myState;
    }

    @Override
    public Date getUpdated() {
        return this.myUpdated;
    }

    @Override
    public Date getCreated() {
        return this.myCreated;
    }

    private static Date parseDate(String date) {
        try {
            return DATE_FORMAT.parse(date);
        }
        catch (ParseException e) {
            return null;
        }
    }

    private static String getChildAttribute(Element parent, String childName, String attributeName) {
        Element child = parent.getChild(childName);
        if (child == null) {
            return null;
        }
        return child.getAttributeValue(attributeName);
    }
}

