/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.javascript.coffeescript.compile.internal;

import java.io.File;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.file.RelativeFile;
import org.gradle.plugins.javascript.coffeescript.CoffeeScriptCompileOptions;
import org.gradle.plugins.javascript.coffeescript.CoffeeScriptCompileSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializableCoffeeScriptCompileSpec
implements Serializable {
    private final File coffeeScriptJs;
    private final File destinationDir;
    private final List<RelativeFile> source;
    private final CoffeeScriptCompileOptions options;

    public SerializableCoffeeScriptCompileSpec(CoffeeScriptCompileSpec spec) {
        this(spec.getCoffeeScriptJs(), spec.getDestinationDir(), spec.getSource(), spec.getOptions());
    }

    public SerializableCoffeeScriptCompileSpec(File coffeeScriptJs, File destinationDir, FileCollection source, CoffeeScriptCompileOptions options) {
        this.coffeeScriptJs = coffeeScriptJs;
        this.destinationDir = destinationDir;
        this.source = new LinkedList<RelativeFile>();
        this.options = options;
        SerializableCoffeeScriptCompileSpec.toRelativeFiles(source, this.source);
    }

    public static void toRelativeFiles(FileCollection source, final List<RelativeFile> targets) {
        FileTree fileTree = source.getAsFileTree();
        fileTree.visit(new FileVisitor(){

            public void visitDir(FileVisitDetails dirDetails) {
            }

            public void visitFile(FileVisitDetails fileDetails) {
                targets.add(new RelativeFile(fileDetails.getFile(), fileDetails.getRelativePath()));
            }
        });
    }

    public File getCoffeeScriptJs() {
        return this.coffeeScriptJs;
    }

    public File getDestinationDir() {
        return this.destinationDir;
    }

    public List<RelativeFile> getSource() {
        return this.source;
    }

    public CoffeeScriptCompileOptions getOptions() {
        return this.options;
    }
}

