/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.sftp;

import java.util.Collections;
import java.util.Set;
import org.gradle.internal.resource.PasswordCredentials;
import org.gradle.internal.resource.connector.ResourceConnectorFactory;
import org.gradle.internal.resource.connector.ResourceConnectorSpecification;
import org.gradle.internal.resource.transfer.DefaultExternalResourceConnector;
import org.gradle.internal.resource.transfer.ExternalResourceAccessor;
import org.gradle.internal.resource.transfer.ExternalResourceConnector;
import org.gradle.internal.resource.transfer.ExternalResourceLister;
import org.gradle.internal.resource.transfer.ExternalResourceUploader;
import org.gradle.internal.resource.transport.sftp.SftpClientFactory;
import org.gradle.internal.resource.transport.sftp.SftpResourceAccessor;
import org.gradle.internal.resource.transport.sftp.SftpResourceLister;
import org.gradle.internal.resource.transport.sftp.SftpResourceUploader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SftpConnectorFactory
implements ResourceConnectorFactory {
    private final SftpClientFactory sftpClientFactory;

    public SftpConnectorFactory(SftpClientFactory sftpClientFactory) {
        this.sftpClientFactory = sftpClientFactory;
    }

    public Set<String> getSupportedProtocols() {
        return Collections.singleton("sftp");
    }

    public ExternalResourceConnector createResourceConnector(ResourceConnectorSpecification connectionDetails) {
        PasswordCredentials passwordCredentials = (PasswordCredentials)connectionDetails.getCredentials(PasswordCredentials.class);
        SftpResourceAccessor accessor = new SftpResourceAccessor(this.sftpClientFactory, passwordCredentials);
        SftpResourceLister lister = new SftpResourceLister(this.sftpClientFactory, passwordCredentials);
        SftpResourceUploader uploader = new SftpResourceUploader(this.sftpClientFactory, passwordCredentials);
        return new DefaultExternalResourceConnector((ExternalResourceAccessor)accessor, (ExternalResourceLister)lister, (ExternalResourceUploader)uploader);
    }
}

