/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.sftp;

import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.net.URI;
import org.gradle.internal.resource.PasswordCredentials;
import org.gradle.internal.resource.ResourceException;
import org.gradle.internal.resource.metadata.DefaultExternalResourceMetaData;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.gradle.internal.resource.transfer.ExternalResourceAccessor;
import org.gradle.internal.resource.transfer.ExternalResourceReadResponse;
import org.gradle.internal.resource.transport.sftp.LockableSftpClient;
import org.gradle.internal.resource.transport.sftp.SftpClientFactory;
import org.gradle.internal.resource.transport.sftp.SftpResource;

public class SftpResourceAccessor
implements ExternalResourceAccessor {
    private final SftpClientFactory sftpClientFactory;
    private final PasswordCredentials credentials;

    public SftpResourceAccessor(SftpClientFactory sftpClientFactory, PasswordCredentials credentials) {
        this.sftpClientFactory = sftpClientFactory;
        this.credentials = credentials;
    }

    public ExternalResourceMetaData getMetaData(URI uri) {
        LockableSftpClient sftpClient = this.sftpClientFactory.createSftpClient(uri, this.credentials);
        try {
            SftpATTRS attributes = sftpClient.getSftpClient().lstat(uri.getPath());
            ExternalResourceMetaData externalResourceMetaData = attributes != null ? this.toMetaData(uri, attributes) : null;
            return externalResourceMetaData;
        }
        catch (SftpException e) {
            if (e.id == 2) {
                ExternalResourceMetaData externalResourceMetaData = null;
                return externalResourceMetaData;
            }
            throw ResourceException.getFailed((URI)uri, (Throwable)e);
        }
        finally {
            this.sftpClientFactory.releaseSftpClient(sftpClient);
        }
    }

    private ExternalResourceMetaData toMetaData(URI uri, SftpATTRS attributes) {
        long lastModified = -1L;
        long contentLength = -1L;
        if ((attributes.getFlags() & 8) != 0) {
            lastModified = attributes.getMTime() * 1000;
        }
        if ((attributes.getFlags() & 1) != 0) {
            contentLength = attributes.getSize();
        }
        return new DefaultExternalResourceMetaData(uri, lastModified, contentLength);
    }

    public ExternalResourceReadResponse openResource(URI location) {
        ExternalResourceMetaData metaData = this.getMetaData(location);
        return metaData != null ? new SftpResource(this.sftpClientFactory, metaData, location, this.credentials) : null;
    }
}

