/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.SerializerRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSerializerRegistry<T>
implements SerializerRegistry<T> {
    private final Map<Class<?>, Serializer<?>> serializerMap = new TreeMap(new Comparator<Class<?>>(){

        @Override
        public int compare(Class<?> o1, Class<?> o2) {
            return o1.getName().compareTo(o2.getName());
        }
    });

    @Override
    public <U extends T> void register(Class<U> implementationType, Serializer<U> serializer) {
        this.serializerMap.put(implementationType, serializer);
    }

    @Override
    public Serializer<T> build() {
        if (this.serializerMap.size() == 1) {
            return this.serializerMap.values().iterator().next();
        }
        TaggedTypeSerializer serializer = new TaggedTypeSerializer();
        for (Map.Entry<Class<?>, Serializer<?>> entry : this.serializerMap.entrySet()) {
            serializer.add(entry.getKey(), entry.getValue());
        }
        return serializer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TaggedTypeSerializer<T>
    implements Serializer<T> {
        private final Map<Class<?>, TypeInfo> serializersByType = new HashMap();
        private final Map<Byte, TypeInfo> serializersByTag = new HashMap<Byte, TypeInfo>();

        private TaggedTypeSerializer() {
        }

        private <T> void add(Class<?> type, Serializer<?> serializer) {
            TypeInfo typeInfo = new TypeInfo((byte)this.serializersByTag.size(), serializer);
            this.serializersByType.put(type, typeInfo);
            this.serializersByTag.put(typeInfo.tag, typeInfo);
        }

        @Override
        public T read(Decoder decoder) throws Exception {
            byte tag = decoder.readByte();
            TypeInfo typeInfo = this.serializersByTag.get(tag);
            if (typeInfo == null) {
                throw new IllegalArgumentException(String.format("Unexpected type tag %d found.", tag));
            }
            return typeInfo.serializer.read(decoder);
        }

        @Override
        public void write(Encoder encoder, T value) throws Exception {
            Class targetType = value instanceof Throwable ? Throwable.class : value.getClass();
            TypeInfo typeInfo = this.serializersByType.get(targetType);
            if (typeInfo == null) {
                throw new IllegalArgumentException(String.format("Don't know how to serialize an object of type %s.", value.getClass().getName()));
            }
            encoder.writeByte(typeInfo.tag);
            typeInfo.serializer.write(encoder, value);
        }
    }

    private static class TypeInfo {
        final byte tag;
        final Serializer serializer;

        private TypeInfo(byte tag, Serializer serializer) {
            this.tag = tag;
            this.serializer = serializer;
        }
    }
}

