/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.dispatch;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.AsyncStoppable;
import org.gradle.messaging.dispatch.Dispatch;
import org.gradle.messaging.dispatch.Receive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncReceive<T>
implements AsyncStoppable {
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final Executor executor;
    private final List<Dispatch<? super T>> dispatches = new ArrayList<Dispatch<? super T>>();
    private final Runnable onReceiversExhausted;
    private int receivers;
    private State state = State.Init;

    public AsyncReceive(Executor executor) {
        this(executor, (Runnable)null);
    }

    public AsyncReceive(Executor executor, Runnable onReceiversExhausted) {
        this.executor = executor;
        this.onReceiversExhausted = onReceiversExhausted;
    }

    public AsyncReceive(Executor executor, Dispatch<? super T> dispatch) {
        this(executor, dispatch, null);
    }

    public AsyncReceive(Executor executor, Dispatch<? super T> dispatch, Runnable onReceiversExhausted) {
        this(executor, onReceiversExhausted);
        this.dispatchTo(dispatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchTo(Dispatch<? super T> dispatch) {
        this.lock.lock();
        try {
            this.dispatches.add(dispatch);
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void receiveFrom(final Receive<? extends T> receive) {
        this.onReceiveThreadStart();
        this.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    AsyncReceive.this.receiveMessages(receive);
                }
                finally {
                    AsyncReceive.this.onReceiveThreadExit();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onReceiveThreadStart() {
        this.lock.lock();
        try {
            if (this.state != State.Init) {
                throw new IllegalStateException("This receiver has been stopped.");
            }
            ++this.receivers;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onReceiveThreadExit() {
        this.lock.lock();
        try {
            --this.receivers;
            if (this.receivers == 0 && this.onReceiversExhausted != null) {
                this.onReceiversExhausted.run();
            }
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveMessages(Receive<? extends T> receive) {
        while (true) {
            Dispatch<T> dispatch;
            this.lock.lock();
            try {
                while (this.dispatches.isEmpty() && this.state == State.Init) {
                    try {
                        this.condition.await();
                    }
                    catch (InterruptedException e) {
                        throw UncheckedException.throwAsUncheckedException((Throwable)e);
                    }
                }
                if (this.state != State.Init) {
                    return;
                }
                dispatch = this.dispatches.remove(0);
            }
            finally {
                this.lock.unlock();
            }
            try {
                T message = receive.receive();
                if (message == null) {
                    return;
                }
                dispatch.dispatch(message);
                continue;
            }
            finally {
                this.lock.lock();
                try {
                    this.dispatches.add(dispatch);
                    this.condition.signalAll();
                    continue;
                }
                finally {
                    this.lock.unlock();
                    continue;
                }
            }
            break;
        }
    }

    private void setState(State state) {
        this.state = state;
        this.condition.signalAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestStop() {
        this.lock.lock();
        try {
            this.doRequestStop();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void doRequestStop() {
        if (this.receivers > 0) {
            this.setState(State.Stopping);
        } else {
            this.setState(State.Stopped);
        }
    }

    public void stop() {
        this.lock.lock();
        try {
            this.doRequestStop();
            while (this.receivers > 0) {
                this.condition.await();
            }
            this.setState(State.Stopped);
        }
        catch (InterruptedException e) {
            throw new UncheckedException((Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        Init,
        Stopping,
        Stopped;

    }
}

