/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.dvcs.branch.DvcsTaskHandler;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitLocalBranch;
import git4idea.branch.GitBrancher;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.Collection;
import java.util.List;

public class GitTaskHandler
extends DvcsTaskHandler<GitRepository> {
    private final GitBrancher myBrancher;

    public GitTaskHandler(GitBrancher brancher, GitRepositoryManager repositoryManager, Project project) {
        super((AbstractRepositoryManager)repositoryManager, project, "branch");
        this.myBrancher = brancher;
    }

    protected void checkout(String taskName, List<GitRepository> repos, Runnable callInAwtLater) {
        this.myBrancher.checkout(taskName, repos, callInAwtLater);
    }

    protected void checkoutAsNewBranch(String name, List<GitRepository> repositories) {
        this.myBrancher.checkoutNewBranch(name, repositories);
    }

    protected String getActiveBranch(GitRepository repository) {
        return repository.getCurrentBranchName();
    }

    protected void mergeAndClose(String branch, List<GitRepository> repositories) {
        this.myBrancher.merge(branch, GitBrancher.DeleteOnMergeOption.DELETE, repositories);
    }

    protected boolean hasBranch(GitRepository repository, String name) {
        return repository.getBranches().findLocalBranch(name) != null;
    }

    protected Collection<String> getAllBranches(GitRepository repository) {
        return ContainerUtil.map(repository.getBranches().getLocalBranches(), (Function)new Function<GitLocalBranch, String>(){

            public String fun(GitLocalBranch branch) {
                return branch.getName();
            }
        });
    }
}

