/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsUser;
import git4idea.GitVcs;
import git4idea.config.GitConfigUtil;
import java.util.List;
import java.util.Map;

public class GitUserRegistry
implements Disposable,
VcsListener {
    private static final Logger LOG = Logger.getInstance(GitUserRegistry.class);
    private final Project myProject;
    private final ProjectLevelVcsManager myVcsManager;
    private final VcsLogObjectsFactory myFactory;
    private final Map<VirtualFile, VcsUser> myUserMap = ContainerUtil.newConcurrentMap();

    public GitUserRegistry(Project project, ProjectLevelVcsManager vcsManager, VcsLogObjectsFactory factory) {
        this.myProject = project;
        this.myVcsManager = vcsManager;
        this.myFactory = factory;
        Disposer.register((Disposable)this.myProject, (Disposable)this);
    }

    public void activate() {
        this.myProject.getMessageBus().connect().subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)this);
        this.directoryMappingChanged();
    }

    public VcsUser getUser(VirtualFile root) {
        return this.myUserMap.get(root);
    }

    public VcsUser getOrReadUser(VirtualFile root) {
        VcsUser user = this.myUserMap.get(root);
        if (user == null) {
            try {
                user = this.readCurrentUser(this.myProject, root);
                if (user != null) {
                    this.myUserMap.put(root, user);
                }
            }
            catch (VcsException e) {
                LOG.warn("Could not retrieve user name in " + root, (Throwable)e);
            }
        }
        return user;
    }

    private VcsUser readCurrentUser(Project project, VirtualFile root) throws VcsException {
        String userName = GitConfigUtil.getValue(project, root, "user.name");
        String userEmail = StringUtil.notNullize((String)GitConfigUtil.getValue(project, root, "user.email"));
        return userName == null ? null : this.myFactory.createUser(userName, userEmail);
    }

    public void dispose() {
        this.myUserMap.clear();
    }

    public void directoryMappingChanged() {
        GitVcs vcs = GitVcs.getInstance(this.myProject);
        if (vcs == null) {
            return;
        }
        Object[] roots = this.myVcsManager.getRootsUnderVcs((AbstractVcs)vcs);
        final List rootsToCheck = ContainerUtil.filter((Object[])roots, (Condition)new Condition<VirtualFile>(){

            public boolean value(VirtualFile root) {
                return GitUserRegistry.this.getUser(root) == null;
            }
        });
        if (!rootsToCheck.isEmpty()) {
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    for (VirtualFile root : rootsToCheck) {
                        GitUserRegistry.this.getOrReadUser(root);
                    }
                }
            });
        }
    }
}

