/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.TransactionRunnable;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class GitRepositoryAction
extends DumbAwareAction {
    final List<TransactionRunnable> myDelayedTasks = new ArrayList<TransactionRunnable>();

    public void actionPerformed(AnActionEvent e) {
        this.myDelayedTasks.clear();
        FileDocumentManager.getInstance().saveAllDocuments();
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        GitVcs vcs = GitVcs.getInstance(project);
        List<VirtualFile> roots = GitRepositoryAction.getGitRoots(project, vcs);
        if (roots == null) {
            return;
        }
        VirtualFile defaultRoot = GitRepositoryAction.getDefaultRoot(project, roots, (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY));
        HashSet<VirtualFile> affectedRoots = new HashSet<VirtualFile>();
        String actionName = this.getActionName();
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        try {
            this.perform(project, roots, defaultRoot, affectedRoots, exceptions);
        }
        catch (VcsException ex) {
            exceptions.add(ex);
        }
        if (this.executeFinalTasksSynchronously()) {
            this.runFinalTasks(project, vcs, affectedRoots, actionName, exceptions);
        }
    }

    private static VirtualFile getDefaultRoot(Project project, List<VirtualFile> roots, VirtualFile[] vFiles) {
        GitRepository currentRepository;
        if (vFiles != null) {
            for (VirtualFile file : vFiles) {
                VirtualFile root = GitUtil.gitRootOrNull(file);
                if (root == null) continue;
                return root;
            }
        }
        return (currentRepository = GitBranchUtil.getCurrentRepository(project)) != null ? currentRepository.getRoot() : roots.get(0);
    }

    protected final void runFinalTasks(Project project, GitVcs vcs, Set<VirtualFile> affectedRoots, String actionName, List<VcsException> exceptions) {
        VcsFileUtil.refreshFiles((Project)project, affectedRoots);
        for (TransactionRunnable task : this.myDelayedTasks) {
            task.run(exceptions);
        }
        this.myDelayedTasks.clear();
        vcs.showErrors(exceptions, actionName);
    }

    protected boolean executeFinalTasksSynchronously() {
        return true;
    }

    protected static boolean isRebasing(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project != null) {
            VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
            if (files != null) {
                for (VirtualFile file : files) {
                    GitRepositoryManager manager = GitUtil.getRepositoryManager(project);
                    if (!GitRepositoryAction.isRebasing((GitRepository)manager.getRepositoryForFile(file))) continue;
                    return true;
                }
            }
            if (GitRepositoryAction.isRebasing(GitBranchUtil.getCurrentRepository(project))) {
                return true;
            }
        }
        return false;
    }

    private static boolean isRebasing(GitRepository repository) {
        return repository != null && repository.getState() == Repository.State.REBASING;
    }

    public static List<VirtualFile> getGitRoots(Project project, GitVcs vcs) {
        List<VirtualFile> roots;
        try {
            roots = GitUtil.getGitRoots(project, vcs);
        }
        catch (VcsException e) {
            Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)GitBundle.getString("repository.action.missing.roots.title"));
            return null;
        }
        return roots;
    }

    public final void delayTask(TransactionRunnable task) {
        this.myDelayedTasks.add(task);
    }

    protected abstract String getActionName();

    protected abstract void perform(Project var1, List<VirtualFile> var2, VirtualFile var3, Set<VirtualFile> var4, List<VcsException> var5) throws VcsException;

    public void update(AnActionEvent e) {
        super.update(e);
        boolean enabled = this.isEnabled(e);
        e.getPresentation().setEnabled(enabled);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(enabled);
        } else {
            e.getPresentation().setVisible(true);
        }
    }

    protected boolean isEnabled(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return false;
        }
        GitVcs vcs = GitVcs.getInstance(project);
        VirtualFile[] roots = ProjectLevelVcsManager.getInstance((Project)project).getRootsUnderVcs((AbstractVcs)vcs);
        return roots != null && roots.length != 0;
    }
}

