/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ui.RollbackChangesDialog;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.UIUtil;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.actions.BasicAction;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GitRevert
extends BasicAction {
    @Override
    public boolean perform(Project project, GitVcs vcs, List<VcsException> exceptions, VirtualFile[] affectedFiles) {
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        if (changeListManager.isFreezedWithNotification("Can not revert now")) {
            return true;
        }
        ArrayList<Change> changes = new ArrayList<Change>(affectedFiles.length);
        for (VirtualFile f : affectedFiles) {
            Change ch = changeListManager.getChange(f);
            if (ch == null) continue;
            changes.add(ch);
        }
        RollbackChangesDialog.rollbackChanges((Project)project, changes);
        for (GitRepository repository : GitUtil.getRepositoriesForFiles(project, Arrays.asList(affectedFiles))) {
            repository.update();
        }
        return false;
    }

    @Override
    protected String getActionName() {
        return UIUtil.removeMnemonic((String)GitBundle.getString("revert.action.name"));
    }

    @Override
    protected boolean isEnabled(Project project, GitVcs vcs, VirtualFile ... vFiles) {
        for (VirtualFile file : vFiles) {
            FileStatus fileStatus = FileStatusManager.getInstance((Project)project).getStatus(file);
            if (!file.isDirectory() && (fileStatus == FileStatus.NOT_CHANGED || fileStatus == FileStatus.UNKNOWN)) continue;
            return true;
        }
        return false;
    }
}

