/*
 * Decompiled with CFR 0.152.
 */
package git4idea.annotate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.annotate.AnnotationSourceSwitcher;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspect;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspectAdapter;
import com.intellij.openapi.vcs.annotate.ShowAllAffectedGenericAction;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.DateFormatUtil;
import git4idea.GitRevisionNumber;
import git4idea.GitVcs;
import git4idea.i18n.GitBundle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GitFileAnnotation
extends FileAnnotation {
    private final StringBuffer myContentBuffer = new StringBuffer();
    private final ArrayList<LineInfo> myLines = new ArrayList();
    private final Project myProject;
    private final VcsRevisionNumber myBaseRevision;
    private final Map<VcsRevisionNumber, VcsFileRevision> myRevisionMap = new HashMap<VcsRevisionNumber, VcsFileRevision>();
    private final VirtualFile myFile;
    private final GitVcs myVcs;
    private final LineAnnotationAspect DATE_ASPECT = new GitAnnotationAspect(LineAnnotationAspect.DATE, true){

        @Override
        public String doGetValue(LineInfo info) {
            Date date = info.getDate();
            return date == null ? "" : DateFormatUtil.formatPrettyDate((Date)date);
        }
    };
    private final LineAnnotationAspect REVISION_ASPECT = new GitAnnotationAspect(LineAnnotationAspect.REVISION, false){

        @Override
        protected String doGetValue(LineInfo lineInfo) {
            GitRevisionNumber revision = lineInfo.getRevision();
            return revision == null ? "" : String.valueOf(revision.getShortRev());
        }
    };
    private final LineAnnotationAspect AUTHOR_ASPECT = new GitAnnotationAspect(LineAnnotationAspect.AUTHOR, true){

        @Override
        protected String doGetValue(LineInfo lineInfo) {
            String author = lineInfo.getAuthor();
            return author == null ? "" : author;
        }
    };

    public GitFileAnnotation(Project project, VirtualFile file, VcsRevisionNumber revision) {
        super(project);
        this.myProject = project;
        this.myVcs = (GitVcs)((Object)ObjectUtils.assertNotNull((Object)((Object)GitVcs.getInstance(this.myProject))));
        this.myFile = file;
        this.myBaseRevision = revision == null ? this.myVcs.getDiffProvider().getCurrentRevision(file) : revision;
    }

    public void addLogEntries(List<VcsFileRevision> revisions) {
        for (VcsFileRevision vcsFileRevision : revisions) {
            this.myRevisionMap.put(vcsFileRevision.getRevisionNumber(), vcsFileRevision);
        }
    }

    public void dispose() {
    }

    public LineAnnotationAspect[] getAspects() {
        return new LineAnnotationAspect[]{this.REVISION_ASPECT, this.DATE_ASPECT, this.AUTHOR_ASPECT};
    }

    public String getToolTip(int lineNumber) {
        if (this.myLines.size() <= lineNumber || lineNumber < 0) {
            return "";
        }
        LineInfo info = this.myLines.get(lineNumber);
        VcsFileRevision fileRevision = this.myRevisionMap.get(info.getRevision());
        if (fileRevision != null) {
            return GitBundle.message("annotation.tool.tip", info.getRevision().asString(), info.getAuthor(), info.getDate(), fileRevision.getCommitMessage());
        }
        return "";
    }

    public String getAnnotatedContent() {
        return this.myContentBuffer.toString();
    }

    public List<VcsFileRevision> getRevisions() {
        ArrayList<VcsFileRevision> result = new ArrayList<VcsFileRevision>(this.myRevisionMap.values());
        Collections.sort(result, new Comparator<VcsFileRevision>(){

            @Override
            public int compare(VcsFileRevision o1, VcsFileRevision o2) {
                return -1 * o1.getRevisionNumber().compareTo((Object)o2.getRevisionNumber());
            }
        });
        return result;
    }

    public boolean revisionsNotEmpty() {
        return !this.myRevisionMap.isEmpty();
    }

    public AnnotationSourceSwitcher getAnnotationSourceSwitcher() {
        return null;
    }

    public int getLineCount() {
        return this.myLines.size();
    }

    public VcsRevisionNumber getLineRevisionNumber(int lineNumber) {
        if (this.lineNumberCheck(lineNumber)) {
            return null;
        }
        return this.myLines.get(lineNumber).getRevision();
    }

    private boolean lineNumberCheck(int lineNumber) {
        return this.myLines.size() <= lineNumber || lineNumber < 0;
    }

    public Date getLineDate(int lineNumber) {
        if (this.lineNumberCheck(lineNumber)) {
            return null;
        }
        return this.myLines.get(lineNumber).getDate();
    }

    public VcsRevisionNumber originalRevision(int lineNumber) {
        return this.getLineRevisionNumber(lineNumber);
    }

    public void appendLineInfo(Date date, GitRevisionNumber revision, String author, String line, long lineNumber) throws VcsException {
        int expectedLineNo = this.myLines.size() + 1;
        if (lineNumber != (long)expectedLineNo) {
            throw new VcsException("Adding for info for line " + lineNumber + " but we are expecting it to be for " + expectedLineNo);
        }
        this.myLines.add(new LineInfo(date, revision, author));
        this.myContentBuffer.append(line);
    }

    public int getNumLines() {
        return this.myLines.size();
    }

    public VirtualFile getFile() {
        return this.myFile;
    }

    public VcsRevisionNumber getCurrentRevision() {
        return this.myBaseRevision;
    }

    public VcsKey getVcsKey() {
        return GitVcs.getKey();
    }

    public boolean isBaseRevisionChanged(VcsRevisionNumber number) {
        VcsRevisionNumber currentCurrentRevision = this.myVcs.getDiffProvider().getCurrentRevision(this.myFile);
        return this.myBaseRevision != null && !this.myBaseRevision.equals(currentCurrentRevision);
    }

    static class LineInfo {
        private final Date myDate;
        private final GitRevisionNumber myRevision;
        private final String myAuthor;

        public LineInfo(Date date, GitRevisionNumber revision, String author) {
            this.myDate = date;
            this.myRevision = revision;
            this.myAuthor = author;
        }

        public Date getDate() {
            return this.myDate;
        }

        public GitRevisionNumber getRevision() {
            return this.myRevision;
        }

        public String getAuthor() {
            return this.myAuthor;
        }
    }

    private abstract class GitAnnotationAspect
    extends LineAnnotationAspectAdapter {
        public GitAnnotationAspect(String id, boolean showByDefault) {
            super(id, showByDefault);
        }

        public String getValue(int lineNumber) {
            if (GitFileAnnotation.this.lineNumberCheck(lineNumber)) {
                return "";
            }
            return this.doGetValue((LineInfo)GitFileAnnotation.this.myLines.get(lineNumber));
        }

        protected abstract String doGetValue(LineInfo var1);

        protected void showAffectedPaths(int lineNum) {
            if (lineNum >= 0 && lineNum < GitFileAnnotation.this.myLines.size()) {
                LineInfo info = (LineInfo)GitFileAnnotation.this.myLines.get(lineNum);
                ShowAllAffectedGenericAction.showSubmittedFiles((Project)GitFileAnnotation.this.myProject, (VcsRevisionNumber)info.getRevision(), (VirtualFile)GitFileAnnotation.this.myFile, (VcsKey)GitVcs.getKey());
            }
        }
    }
}

