/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import git4idea.GitLocalBranch;
import git4idea.GitPlatformFacade;
import git4idea.GitUtil;
import git4idea.branch.GitBranchUiHandler;
import git4idea.commands.Git;
import git4idea.commands.GitMessageWithFilesDetector;
import git4idea.config.GitVcsSettings;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

abstract class GitBranchOperation {
    protected static final Logger LOG = Logger.getInstance(GitBranchOperation.class);
    protected final Project myProject;
    protected final GitPlatformFacade myFacade;
    protected final Git myGit;
    protected final GitBranchUiHandler myUiHandler;
    private final Collection<GitRepository> myRepositories;
    protected final Map<GitRepository, String> myCurrentHeads;
    private final GitVcsSettings mySettings;
    private final Collection<GitRepository> mySuccessfulRepositories;
    private final Collection<GitRepository> myRemainingRepositories;

    protected GitBranchOperation(Project project, GitPlatformFacade facade, Git git, GitBranchUiHandler uiHandler, Collection<GitRepository> repositories) {
        this.myProject = project;
        this.myFacade = facade;
        this.myGit = git;
        this.myUiHandler = uiHandler;
        this.myRepositories = repositories;
        this.myCurrentHeads = ContainerUtil.map2Map(repositories, (Function)new Function<GitRepository, Pair<GitRepository, String>>(){

            public Pair<GitRepository, String> fun(GitRepository repository) {
                GitLocalBranch currentBranch = repository.getCurrentBranch();
                return Pair.create((Object)repository, (Object)(currentBranch == null ? repository.getCurrentRevision() : currentBranch.getName()));
            }
        });
        this.mySuccessfulRepositories = new ArrayList<GitRepository>();
        this.myRemainingRepositories = new ArrayList<GitRepository>(this.myRepositories);
        this.mySettings = this.myFacade.getSettings(this.myProject);
    }

    protected abstract void execute();

    protected abstract void rollback();

    public abstract String getSuccessMessage();

    protected abstract String getRollbackProposal();

    protected abstract String getOperationName();

    protected GitRepository next() {
        return this.myRemainingRepositories.iterator().next();
    }

    protected boolean hasMoreRepositories() {
        return !this.myRemainingRepositories.isEmpty();
    }

    protected void markSuccessful(GitRepository ... repositories) {
        for (GitRepository repository : repositories) {
            this.mySuccessfulRepositories.add(repository);
            this.myRemainingRepositories.remove(repository);
        }
    }

    protected boolean wereSuccessful() {
        return !this.mySuccessfulRepositories.isEmpty();
    }

    protected Collection<GitRepository> getSuccessfulRepositories() {
        return this.mySuccessfulRepositories;
    }

    protected String successfulRepositoriesJoined() {
        return StringUtil.join(this.mySuccessfulRepositories, (Function)new Function<GitRepository, String>(){

            public String fun(GitRepository repository) {
                return repository.getPresentableUrl();
            }
        }, (String)"<br/>");
    }

    protected Collection<GitRepository> getRepositories() {
        return this.myRepositories;
    }

    protected Collection<GitRepository> getRemainingRepositories() {
        return this.myRemainingRepositories;
    }

    protected List<GitRepository> getRemainingRepositoriesExceptGiven(GitRepository currentRepository) {
        ArrayList<GitRepository> repositories = new ArrayList<GitRepository>(this.myRemainingRepositories);
        repositories.remove(currentRepository);
        return repositories;
    }

    protected void notifySuccess(String message) {
        VcsNotifier.getInstance((Project)this.myProject).notifySuccess(message);
    }

    protected final void notifySuccess() {
        this.notifySuccess(this.getSuccessMessage());
    }

    protected final void saveAllDocuments() {
        this.myFacade.saveAllDocuments();
    }

    protected void fatalError(String title, String message) {
        if (this.wereSuccessful()) {
            this.showFatalErrorDialogWithRollback(title, message);
        } else {
            this.showFatalNotification(title, message);
        }
    }

    protected void showFatalErrorDialogWithRollback(String title, String message) {
        boolean rollback = this.myUiHandler.notifyErrorWithRollbackProposal(title, message, this.getRollbackProposal());
        if (rollback) {
            this.rollback();
        }
    }

    protected void showFatalNotification(String title, String message) {
        this.notifyError(title, message);
    }

    protected void notifyError(String title, String message) {
        VcsNotifier.getInstance((Project)this.myProject).notifyError(title, message);
    }

    protected ProgressIndicator getIndicator() {
        return this.myUiHandler.getProgressIndicator();
    }

    protected void fatalUnmergedFilesError() {
        if (this.wereSuccessful()) {
            this.showUnmergedFilesDialogWithRollback();
        } else {
            this.showUnmergedFilesNotification();
        }
    }

    protected String repositories() {
        return StringUtil.pluralize((String)"repository", (int)this.getSuccessfulRepositories().size());
    }

    protected void updateRecentBranch() {
        if (this.getRepositories().size() == 1) {
            GitRepository repository = this.myRepositories.iterator().next();
            this.mySettings.setRecentBranchOfRepository(repository.getRoot().getPath(), this.myCurrentHeads.get(repository));
        } else {
            String recentCommonBranch = this.getRecentCommonBranch();
            if (recentCommonBranch != null) {
                this.mySettings.setRecentCommonBranch(recentCommonBranch);
            }
        }
    }

    private String getRecentCommonBranch() {
        String recentCommonBranch = null;
        for (String branch : this.myCurrentHeads.values()) {
            if (recentCommonBranch == null) {
                recentCommonBranch = branch;
                continue;
            }
            if (recentCommonBranch.equals(branch)) continue;
            return null;
        }
        return recentCommonBranch;
    }

    private void showUnmergedFilesDialogWithRollback() {
        boolean ok = this.myUiHandler.showUnmergedFilesMessageWithRollback(this.getOperationName(), this.getRollbackProposal());
        if (ok) {
            this.rollback();
        }
    }

    private void showUnmergedFilesNotification() {
        this.myUiHandler.showUnmergedFilesNotification(this.getOperationName(), this.getRepositories());
    }

    protected void refreshRoot(GitRepository repository) {
        this.myFacade.hardRefresh(repository.getRoot());
    }

    protected void fatalLocalChangesError(String reference) {
        String title = String.format("Couldn't %s %s", this.getOperationName(), reference);
        if (this.wereSuccessful()) {
            this.showFatalErrorDialogWithRollback(title, "");
        }
    }

    protected void fatalUntrackedFilesError(VirtualFile root, Collection<String> relativePaths) {
        if (this.wereSuccessful()) {
            this.showUntrackedFilesDialogWithRollback(root, relativePaths);
        } else {
            this.showUntrackedFilesNotification(root, relativePaths);
        }
    }

    private void showUntrackedFilesNotification(VirtualFile root, Collection<String> relativePaths) {
        this.myUiHandler.showUntrackedFilesNotification(this.getOperationName(), root, relativePaths);
    }

    private void showUntrackedFilesDialogWithRollback(VirtualFile root, Collection<String> relativePaths) {
        boolean ok = this.myUiHandler.showUntrackedFilesDialogWithRollback(this.getOperationName(), this.getRollbackProposal(), root, relativePaths);
        if (ok) {
            this.rollback();
        }
    }

    Map<GitRepository, List<Change>> collectLocalChangesConflictingWithBranch(Collection<GitRepository> repositories, String currentBranch, String otherBranch) {
        HashMap<GitRepository, List<Change>> changes = new HashMap<GitRepository, List<Change>>();
        for (GitRepository repository : repositories) {
            try {
                Collection<String> diff = GitUtil.getPathsDiffBetweenRefs(this.myGit, repository, currentBranch, otherBranch);
                List<Change> changesInRepo = GitUtil.findLocalChangesForPaths(this.myProject, repository.getRoot(), diff, false);
                if (changesInRepo.isEmpty()) continue;
                changes.put(repository, changesInRepo);
            }
            catch (VcsException e) {
                LOG.warn(String.format("Couldn't collect diff between %s and %s in %s", currentBranch, otherBranch, repository.getRoot()), (Throwable)e);
            }
        }
        return changes;
    }

    protected Pair<List<GitRepository>, List<Change>> getConflictingRepositoriesAndAffectedChanges(GitRepository currentRepository, GitMessageWithFilesDetector localChangesOverwrittenBy, String currentBranch, String nextBranch) {
        List<Change> affectedChanges = GitUtil.findLocalChangesForPaths(this.myProject, currentRepository.getRoot(), localChangesOverwrittenBy.getRelativeFilePaths(), true);
        Map<GitRepository, List<Change>> conflictingChangesInRepositories = this.collectLocalChangesConflictingWithBranch(this.getRemainingRepositoriesExceptGiven(currentRepository), currentBranch, nextBranch);
        Set<GitRepository> otherProblematicRepositories = conflictingChangesInRepositories.keySet();
        ArrayList<GitRepository> allConflictingRepositories = new ArrayList<GitRepository>(otherProblematicRepositories);
        allConflictingRepositories.add(currentRepository);
        for (List<Change> changes : conflictingChangesInRepositories.values()) {
            affectedChanges.addAll(changes);
        }
        return Pair.create(allConflictingRepositories, affectedChanges);
    }

    protected static String stringifyBranchesByRepos(Map<GitRepository, String> heads) {
        MultiMap<String, VirtualFile> grouped = GitBranchOperation.groupByBranches(heads);
        if (grouped.size() == 1) {
            return (String)grouped.keySet().iterator().next();
        }
        return StringUtil.join((Collection)grouped.entrySet(), (Function)new Function<Map.Entry<String, Collection<VirtualFile>>, String>(){

            public String fun(Map.Entry<String, Collection<VirtualFile>> entry) {
                String roots = StringUtil.join(entry.getValue(), (Function)new Function<VirtualFile, String>(){

                    public String fun(VirtualFile file) {
                        return file.getName();
                    }
                }, (String)", ");
                return entry.getKey() + " (in " + roots + ")";
            }
        }, (String)"<br/>");
    }

    private static MultiMap<String, VirtualFile> groupByBranches(Map<GitRepository, String> heads) {
        MultiMap result = MultiMap.createLinked();
        List sortedRepos = DvcsUtil.sortRepositories(heads.keySet());
        for (GitRepository repo : sortedRepos) {
            result.putValue((Object)heads.get(repo), (Object)repo.getRoot());
        }
        return result;
    }
}

