/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitCommit;
import git4idea.GitExecutionException;
import git4idea.GitLocalBranch;
import git4idea.GitPlatformFacade;
import git4idea.branch.GitBranchUiHandler;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBrancher;
import git4idea.branch.GitCheckoutNewBranchOperation;
import git4idea.branch.GitCheckoutOperation;
import git4idea.branch.GitDeleteBranchOperation;
import git4idea.branch.GitDeleteRemoteBranchOperation;
import git4idea.branch.GitMergeOperation;
import git4idea.changes.GitChangeUtils;
import git4idea.commands.Git;
import git4idea.history.GitHistoryUtils;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitCompareBranchesDialog;
import git4idea.util.GitCommitCompareInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public final class GitBranchWorker {
    private static final Logger LOG = Logger.getInstance(GitBranchWorker.class);
    private final Project myProject;
    private final GitPlatformFacade myFacade;
    private final Git myGit;
    private final GitBranchUiHandler myUiHandler;

    public GitBranchWorker(Project project, GitPlatformFacade facade, Git git, GitBranchUiHandler uiHandler) {
        this.myProject = project;
        this.myFacade = facade;
        this.myGit = git;
        this.myUiHandler = uiHandler;
    }

    public void checkoutNewBranch(final String name, List<GitRepository> repositories) {
        GitBranchWorker.updateInfo(repositories);
        repositories = ContainerUtil.filter(repositories, (Condition)new Condition<GitRepository>(){

            public boolean value(GitRepository repository) {
                GitLocalBranch currentBranch = repository.getCurrentBranch();
                return currentBranch == null || !currentBranch.getName().equals(name);
            }
        });
        if (!repositories.isEmpty()) {
            new GitCheckoutNewBranchOperation(this.myProject, this.myFacade, this.myGit, this.myUiHandler, repositories, name).execute();
        } else {
            LOG.error("Creating new branch the same as current in all repositories: " + name);
        }
    }

    public void createNewTag(String name, String reference, List<GitRepository> repositories) {
        for (GitRepository repository : repositories) {
            this.myGit.createNewTag(repository, name, null, reference);
            VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{repository.getGitDir()});
        }
    }

    public void checkoutNewBranchStartingFrom(String newBranchName, String startPoint, List<GitRepository> repositories) {
        GitBranchWorker.updateInfo(repositories);
        new GitCheckoutOperation(this.myProject, this.myFacade, this.myGit, this.myUiHandler, repositories, startPoint, newBranchName).execute();
    }

    public void checkout(String reference, List<GitRepository> repositories) {
        GitBranchWorker.updateInfo(repositories);
        new GitCheckoutOperation(this.myProject, this.myFacade, this.myGit, this.myUiHandler, repositories, reference, null).execute();
    }

    public void deleteBranch(String branchName, List<GitRepository> repositories) {
        GitBranchWorker.updateInfo(repositories);
        new GitDeleteBranchOperation(this.myProject, this.myFacade, this.myGit, this.myUiHandler, repositories, branchName).execute();
    }

    public void deleteRemoteBranch(String branchName, List<GitRepository> repositories) {
        GitBranchWorker.updateInfo(repositories);
        new GitDeleteRemoteBranchOperation(this.myProject, this.myFacade, this.myGit, this.myUiHandler, repositories, branchName).execute();
    }

    public void merge(String branchName, GitBrancher.DeleteOnMergeOption deleteOnMerge, List<GitRepository> repositories) {
        GitBranchWorker.updateInfo(repositories);
        HashMap<GitRepository, String> revisions = new HashMap<GitRepository, String>();
        for (GitRepository repository : repositories) {
            revisions.put(repository, repository.getCurrentRevision());
        }
        new GitMergeOperation(this.myProject, this.myFacade, this.myGit, this.myUiHandler, repositories, branchName, deleteOnMerge, revisions).execute();
    }

    public void compare(final String branchName, final List<GitRepository> repositories, final GitRepository selectedRepository) {
        final GitCommitCompareInfo myCompareInfo = this.loadCommitsToCompare(repositories, branchName);
        if (myCompareInfo == null) {
            LOG.error("The task to get compare info didn't finish. Repositories: \n" + repositories + "\nbranch name: " + branchName);
            return;
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                GitBranchWorker.this.displayCompareDialog(branchName, GitBranchUtil.getCurrentBranchOrRev(repositories), myCompareInfo, selectedRepository);
            }
        });
    }

    private GitCommitCompareInfo loadCommitsToCompare(List<GitRepository> repositories, String branchName) {
        GitCommitCompareInfo compareInfo = new GitCommitCompareInfo();
        for (GitRepository repository : repositories) {
            compareInfo.put(repository, (Pair<List<GitCommit>, List<GitCommit>>)this.loadCommitsToCompare(repository, branchName));
            compareInfo.put(repository, GitBranchWorker.loadTotalDiff(repository, branchName));
        }
        return compareInfo;
    }

    private static Collection<Change> loadTotalDiff(GitRepository repository, String branchName) {
        try {
            return GitChangeUtils.getDiff(repository.getProject(), repository.getRoot(), null, branchName, null);
        }
        catch (VcsException e) {
            throw new GitExecutionException("Couldn't get [git diff " + branchName + "] on repository [" + repository.getRoot() + "]", e);
        }
    }

    private Couple<List<GitCommit>> loadCommitsToCompare(GitRepository repository, String branchName) {
        List<GitCommit> branchToHead;
        List<GitCommit> headToBranch;
        try {
            headToBranch = GitHistoryUtils.history(this.myProject, repository.getRoot(), ".." + branchName);
            branchToHead = GitHistoryUtils.history(this.myProject, repository.getRoot(), branchName + "..");
        }
        catch (VcsException e) {
            throw new GitExecutionException("Couldn't get [git log .." + branchName + "] on repository [" + repository.getRoot() + "]", e);
        }
        return Couple.of(headToBranch, branchToHead);
    }

    private void displayCompareDialog(String branchName, String currentBranch, GitCommitCompareInfo compareInfo, GitRepository selectedRepository) {
        if (compareInfo.isEmpty()) {
            Messages.showInfoMessage((Project)this.myProject, (String)String.format("<html>There are no changes between <code>%s</code> and <code>%s</code></html>", currentBranch, branchName), (String)"No Changes Detected");
        } else {
            new GitCompareBranchesDialog(this.myProject, branchName, currentBranch, compareInfo, selectedRepository).show();
        }
    }

    private static void updateInfo(Collection<GitRepository> repositories) {
        for (GitRepository repository : repositories) {
            repository.update();
        }
    }
}

