/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import git4idea.GitPlatformFacade;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUiHandlerImpl;
import git4idea.branch.GitBranchWorker;
import git4idea.branch.GitBrancher;
import git4idea.commands.Git;
import git4idea.repo.GitRepository;
import java.util.List;

class GitBrancherImpl
implements GitBrancher {
    private final Project myProject;
    private final GitPlatformFacade myFacade;
    private final Git myGit;

    GitBrancherImpl(Project project, GitPlatformFacade facade, Git git) {
        this.myProject = project;
        this.myFacade = facade;
        this.myGit = git;
    }

    @Override
    public void checkoutNewBranch(final String name, final List<GitRepository> repositories) {
        new CommonBackgroundTask(this.myProject, "Checking out new branch " + name, null){

            @Override
            public void execute(ProgressIndicator indicator) {
                GitBrancherImpl.this.newWorker(indicator).checkoutNewBranch(name, repositories);
            }
        }.runInBackground();
    }

    private GitBranchWorker newWorker(ProgressIndicator indicator) {
        return new GitBranchWorker(this.myProject, this.myFacade, this.myGit, new GitBranchUiHandlerImpl(this.myProject, this.myFacade, this.myGit, indicator));
    }

    @Override
    public void createNewTag(final String name, final String reference, final List<GitRepository> repositories, Runnable callInAwtLater) {
        new CommonBackgroundTask(this.myProject, "Checking out new branch " + name, callInAwtLater){

            @Override
            public void execute(ProgressIndicator indicator) {
                GitBrancherImpl.this.newWorker(indicator).createNewTag(name, reference, repositories);
            }
        }.runInBackground();
    }

    @Override
    public void checkout(final String reference, final List<GitRepository> repositories, Runnable callInAwtLater) {
        new CommonBackgroundTask(this.myProject, "Checking out " + reference, callInAwtLater){

            @Override
            public void execute(ProgressIndicator indicator) {
                GitBrancherImpl.this.newWorker(indicator).checkout(reference, repositories);
            }
        }.runInBackground();
    }

    @Override
    public void checkoutNewBranchStartingFrom(final String newBranchName, final String startPoint, final List<GitRepository> repositories, Runnable callInAwtLater) {
        new CommonBackgroundTask(this.myProject, String.format("Checking out %s from %s", newBranchName, startPoint), callInAwtLater){

            @Override
            public void execute(ProgressIndicator indicator) {
                GitBrancherImpl.this.newWorker(indicator).checkoutNewBranchStartingFrom(newBranchName, startPoint, repositories);
            }
        }.runInBackground();
    }

    @Override
    public void deleteBranch(final String branchName, final List<GitRepository> repositories) {
        new CommonBackgroundTask(this.myProject, "Deleting " + branchName, null){

            @Override
            public void execute(ProgressIndicator indicator) {
                GitBrancherImpl.this.newWorker(indicator).deleteBranch(branchName, repositories);
            }
        }.runInBackground();
    }

    @Override
    public void deleteRemoteBranch(final String branchName, final List<GitRepository> repositories) {
        new CommonBackgroundTask(this.myProject, "Deleting " + branchName, null){

            @Override
            public void execute(ProgressIndicator indicator) {
                GitBrancherImpl.this.newWorker(indicator).deleteRemoteBranch(branchName, repositories);
            }
        }.runInBackground();
    }

    @Override
    public void compare(final String branchName, final List<GitRepository> repositories, final GitRepository selectedRepository) {
        new CommonBackgroundTask(this.myProject, "Comparing with " + branchName, null){

            @Override
            public void execute(ProgressIndicator indicator) {
                GitBrancherImpl.this.newWorker(indicator).compare(branchName, repositories, selectedRepository);
            }
        }.runInBackground();
    }

    @Override
    public void merge(final String branchName, final GitBrancher.DeleteOnMergeOption deleteOnMerge, final List<GitRepository> repositories) {
        new CommonBackgroundTask(this.myProject, "Merging " + branchName, null){

            @Override
            public void execute(ProgressIndicator indicator) {
                GitBrancherImpl.this.newWorker(indicator).merge(branchName, deleteOnMerge, repositories);
            }
        }.runInBackground();
    }

    private static abstract class CommonBackgroundTask
    extends Task.Backgroundable {
        private final Runnable myCallInAwtAfterExecution;

        private CommonBackgroundTask(Project project, String title, Runnable callInAwtAfterExecution) {
            super(project, title);
            this.myCallInAwtAfterExecution = callInAwtAfterExecution;
        }

        public final void run(ProgressIndicator indicator) {
            this.execute(indicator);
            if (this.myCallInAwtAfterExecution != null) {
                Application application = ApplicationManager.getApplication();
                if (application.isUnitTestMode()) {
                    this.myCallInAwtAfterExecution.run();
                } else {
                    application.invokeLater(this.myCallInAwtAfterExecution, application.getDefaultModalityState());
                }
            }
        }

        abstract void execute(ProgressIndicator var1);

        void runInBackground() {
            GitVcs.runInBackground(this);
        }
    }
}

