/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitReference;
import git4idea.GitRemoteBranch;
import java.util.Collection;
import java.util.Collections;

public final class GitBranchesCollection {
    public static final GitBranchesCollection EMPTY = new GitBranchesCollection(Collections.<GitLocalBranch>emptyList(), Collections.<GitRemoteBranch>emptyList());
    private final Collection<GitLocalBranch> myLocalBranches;
    private final Collection<GitRemoteBranch> myRemoteBranches;

    public GitBranchesCollection(Collection<GitLocalBranch> localBranches, Collection<GitRemoteBranch> remoteBranches) {
        this.myRemoteBranches = remoteBranches;
        this.myLocalBranches = localBranches;
    }

    public Collection<GitLocalBranch> getLocalBranches() {
        return Collections.unmodifiableCollection(this.myLocalBranches);
    }

    public Collection<GitRemoteBranch> getRemoteBranches() {
        return Collections.unmodifiableCollection(this.myRemoteBranches);
    }

    public GitLocalBranch findLocalBranch(String name) {
        return GitBranchesCollection.findByName(this.myLocalBranches, name);
    }

    public GitBranch findBranchByName(String name) {
        GitLocalBranch branch = GitBranchesCollection.findByName(this.myLocalBranches, name);
        return branch != null ? branch : GitBranchesCollection.findByName(this.myRemoteBranches, name);
    }

    private static <T extends GitBranch> T findByName(Collection<T> branches, final String name) {
        return (T)((GitBranch)ContainerUtil.find(branches, (Condition)new Condition<T>(){

            public boolean value(T branch) {
                return name.equals(((GitReference)branch).getName());
            }
        }));
    }
}

