/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.UIUtil;
import git4idea.GitPlatformFacade;
import git4idea.GitUtil;
import git4idea.branch.GitBranchOperation;
import git4idea.branch.GitBranchUiHandler;
import git4idea.branch.GitBrancher;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitCompoundResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitLocalChangesWouldBeOverwrittenDetector;
import git4idea.commands.GitMessageWithFilesDetector;
import git4idea.commands.GitSimpleEventDetector;
import git4idea.commands.GitUntrackedFilesOverwrittenByOperationDetector;
import git4idea.merge.GitConflictResolver;
import git4idea.merge.GitMergeCommittingConflictResolver;
import git4idea.merge.GitMerger;
import git4idea.repo.GitRepository;
import git4idea.reset.GitResetMode;
import git4idea.util.GitPreservingProcess;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.HyperlinkEvent;

class GitMergeOperation
extends GitBranchOperation {
    private static final Logger LOG = Logger.getInstance(GitMergeOperation.class);
    public static final String ROLLBACK_PROPOSAL = "You may rollback (reset to the commit before merging) not to let branches diverge.";
    private final ChangeListManager myChangeListManager;
    private final String myBranchToMerge;
    private final GitBrancher.DeleteOnMergeOption myDeleteOnMerge;
    private final Map<GitRepository, String> myCurrentRevisionsBeforeMerge;
    private final Map<GitRepository, Boolean> myConflictedRepositories = new HashMap<GitRepository, Boolean>();
    private GitPreservingProcess myPreservingProcess;

    GitMergeOperation(Project project, GitPlatformFacade facade, Git git, GitBranchUiHandler uiHandler, Collection<GitRepository> repositories, String branchToMerge, GitBrancher.DeleteOnMergeOption deleteOnMerge, Map<GitRepository, String> currentRevisionsBeforeMerge) {
        super(project, facade, git, uiHandler, repositories);
        this.myBranchToMerge = branchToMerge;
        this.myDeleteOnMerge = deleteOnMerge;
        this.myCurrentRevisionsBeforeMerge = currentRevisionsBeforeMerge;
        this.myChangeListManager = this.myFacade.getChangeListManager(this.myProject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute() {
        LOG.info("starting");
        this.saveAllDocuments();
        boolean fatalErrorHappened = false;
        int alreadyUpToDateRepositories = 0;
        AccessToken token = DvcsUtil.workingTreeChangeStarted((Project)this.myProject);
        try {
            while (this.hasMoreRepositories() && !fatalErrorHappened) {
                GitRepository repository = this.next();
                LOG.info("next repository: " + repository);
                VirtualFile root = repository.getRoot();
                GitLocalChangesWouldBeOverwrittenDetector localChangesDetector = new GitLocalChangesWouldBeOverwrittenDetector(root, GitLocalChangesWouldBeOverwrittenDetector.Operation.MERGE);
                GitSimpleEventDetector unmergedFiles = new GitSimpleEventDetector(GitSimpleEventDetector.Event.UNMERGED_PREVENTING_MERGE);
                GitUntrackedFilesOverwrittenByOperationDetector untrackedOverwrittenByMerge = new GitUntrackedFilesOverwrittenByOperationDetector(root);
                GitSimpleEventDetector mergeConflict = new GitSimpleEventDetector(GitSimpleEventDetector.Event.MERGE_CONFLICT);
                GitSimpleEventDetector alreadyUpToDateDetector = new GitSimpleEventDetector(GitSimpleEventDetector.Event.ALREADY_UP_TO_DATE);
                GitCommandResult result = this.myGit.merge(repository, this.myBranchToMerge, Collections.<String>emptyList(), localChangesDetector, unmergedFiles, untrackedOverwrittenByMerge, mergeConflict, alreadyUpToDateDetector);
                if (result.success()) {
                    LOG.info("Merged successfully");
                    this.refresh(repository);
                    this.markSuccessful(repository);
                    if (!alreadyUpToDateDetector.hasHappened()) continue;
                    ++alreadyUpToDateRepositories;
                    continue;
                }
                if (unmergedFiles.hasHappened()) {
                    LOG.info("Unmerged files error!");
                    this.fatalUnmergedFilesError();
                    fatalErrorHappened = true;
                    continue;
                }
                if (localChangesDetector.wasMessageDetected()) {
                    LOG.info("Local changes would be overwritten by merge!");
                    boolean smartMergeSucceeded = this.proposeSmartMergePerformAndNotify(repository, localChangesDetector);
                    if (smartMergeSucceeded) continue;
                    fatalErrorHappened = true;
                    continue;
                }
                if (mergeConflict.hasHappened()) {
                    LOG.info("Merge conflict");
                    this.myConflictedRepositories.put(repository, Boolean.FALSE);
                    this.refresh(repository);
                    this.markSuccessful(repository);
                    continue;
                }
                if (untrackedOverwrittenByMerge.wasMessageDetected()) {
                    LOG.info("Untracked files would be overwritten by merge!");
                    this.fatalUntrackedFilesError(repository.getRoot(), untrackedOverwrittenByMerge.getRelativeFilePaths());
                    fatalErrorHappened = true;
                    continue;
                }
                LOG.info("Unknown error. " + result);
                this.fatalError(this.getCommonErrorTitle(), result.getErrorOutputAsJoinedString());
                fatalErrorHappened = true;
            }
            if (fatalErrorHappened) {
                this.notifyAboutRemainingConflicts();
            } else {
                boolean allConflictsResolved = this.resolveConflicts();
                if (allConflictsResolved) {
                    if (alreadyUpToDateRepositories < this.getRepositories().size()) {
                        this.notifySuccess();
                    } else {
                        this.notifySuccess("Already up-to-date");
                    }
                }
            }
            this.restoreLocalChanges();
        }
        finally {
            DvcsUtil.workingTreeChangeFinished((Project)this.myProject, (AccessToken)token);
        }
    }

    private void notifyAboutRemainingConflicts() {
        if (!this.myConflictedRepositories.isEmpty()) {
            new MyMergeConflictResolver().notifyUnresolvedRemain();
        }
    }

    @Override
    protected void notifySuccess(String message) {
        switch (this.myDeleteOnMerge) {
            case DELETE: {
                super.notifySuccess(message);
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        GitBrancher brancher = (GitBrancher)ServiceManager.getService((Project)GitMergeOperation.this.myProject, GitBrancher.class);
                        brancher.deleteBranch(GitMergeOperation.this.myBranchToMerge, new ArrayList<GitRepository>(GitMergeOperation.this.getRepositories()));
                    }
                });
                break;
            }
            case PROPOSE: {
                String description = message + "<br/><a href='delete'>Delete " + this.myBranchToMerge + "</a>";
                VcsNotifier.getInstance((Project)this.myProject).notifySuccess("", description, (NotificationListener)new DeleteMergedLocalBranchNotificationListener());
                break;
            }
            case NOTHING: {
                super.notifySuccess(message);
            }
        }
    }

    private boolean resolveConflicts() {
        if (!this.myConflictedRepositories.isEmpty()) {
            return new MyMergeConflictResolver().merge();
        }
        return true;
    }

    private boolean proposeSmartMergePerformAndNotify(GitRepository repository, GitMessageWithFilesDetector localChangesOverwrittenByMerge) {
        Collection<String> absolutePaths;
        Pair<List<GitRepository>, List<Change>> conflictingRepositoriesAndAffectedChanges = this.getConflictingRepositoriesAndAffectedChanges(repository, localChangesOverwrittenByMerge, (String)this.myCurrentHeads.get(repository), this.myBranchToMerge);
        List allConflictingRepositories = (List)conflictingRepositoriesAndAffectedChanges.getFirst();
        List affectedChanges = (List)conflictingRepositoriesAndAffectedChanges.getSecond();
        int smartCheckoutDecision = this.myUiHandler.showSmartOperationDialog(this.myProject, affectedChanges, absolutePaths = GitUtil.toAbsolute(repository.getRoot(), localChangesOverwrittenByMerge.getRelativeFilePaths()), "merge", null);
        if (smartCheckoutDecision == 0) {
            return this.doSmartMerge(allConflictingRepositories);
        }
        this.fatalLocalChangesError(this.myBranchToMerge);
        return false;
    }

    private void restoreLocalChanges() {
        if (this.myPreservingProcess != null) {
            this.myPreservingProcess.load();
        }
    }

    private boolean doSmartMerge(final Collection<GitRepository> repositories) {
        final AtomicBoolean success = new AtomicBoolean();
        this.myPreservingProcess = new GitPreservingProcess(this.myProject, this.myFacade, this.myGit, repositories, "merge", this.myBranchToMerge, this.getIndicator(), new Runnable(){

            @Override
            public void run() {
                success.set(GitMergeOperation.this.doMerge(repositories));
            }
        });
        this.myPreservingProcess.execute(new Computable<Boolean>(){

            public Boolean compute() {
                return GitMergeOperation.this.myConflictedRepositories.isEmpty();
            }
        });
        return success.get();
    }

    private boolean doMerge(Collection<GitRepository> repositories) {
        for (GitRepository repository : repositories) {
            GitSimpleEventDetector mergeConflict = new GitSimpleEventDetector(GitSimpleEventDetector.Event.MERGE_CONFLICT);
            GitCommandResult result = this.myGit.merge(repository, this.myBranchToMerge, Collections.<String>emptyList(), mergeConflict);
            if (!result.success()) {
                if (mergeConflict.hasHappened()) {
                    this.myConflictedRepositories.put(repository, Boolean.TRUE);
                    this.refresh(repository);
                    this.markSuccessful(repository);
                    continue;
                }
                this.fatalError(this.getCommonErrorTitle(), result.getErrorOutputAsJoinedString());
                return false;
            }
            this.refresh(repository);
            this.markSuccessful(repository);
        }
        return true;
    }

    private String getCommonErrorTitle() {
        return "Couldn't merge " + this.myBranchToMerge;
    }

    @Override
    protected void rollback() {
        LOG.info("starting rollback...");
        ArrayList<GitRepository> repositoriesForSmartRollback = new ArrayList<GitRepository>();
        ArrayList<GitRepository> repositoriesForSimpleRollback = new ArrayList<GitRepository>();
        ArrayList<GitRepository> repositoriesForMergeRollback = new ArrayList<GitRepository>();
        for (GitRepository repository : this.getSuccessfulRepositories()) {
            if (this.myConflictedRepositories.containsKey(repository)) {
                repositoriesForMergeRollback.add(repository);
                continue;
            }
            if (this.thereAreLocalChangesIn(repository)) {
                repositoriesForSmartRollback.add(repository);
                continue;
            }
            repositoriesForSimpleRollback.add(repository);
        }
        LOG.info("for smart rollback: " + DvcsUtil.getShortNames(repositoriesForSmartRollback) + "; for simple rollback: " + DvcsUtil.getShortNames(repositoriesForSimpleRollback) + "; for merge rollback: " + DvcsUtil.getShortNames(repositoriesForMergeRollback));
        GitCompoundResult result = this.smartRollback(repositoriesForSmartRollback);
        for (GitRepository repository : repositoriesForSimpleRollback) {
            result.append(repository, this.rollback(repository));
        }
        for (GitRepository repository : repositoriesForMergeRollback) {
            result.append(repository, this.rollbackMerge(repository));
        }
        this.myConflictedRepositories.clear();
        if (!result.totalSuccess()) {
            VcsNotifier.getInstance((Project)this.myProject).notifyError("Error during rollback", result.getErrorOutputWithReposIndication());
        }
        LOG.info("rollback finished.");
    }

    private GitCompoundResult smartRollback(final Collection<GitRepository> repositories) {
        LOG.info("Starting smart rollback...");
        final GitCompoundResult result = new GitCompoundResult(this.myProject);
        GitPreservingProcess preservingProcess = new GitPreservingProcess(this.myProject, this.myFacade, this.myGit, repositories, "merge", this.myBranchToMerge, this.getIndicator(), new Runnable(){

            @Override
            public void run() {
                for (GitRepository repository : repositories) {
                    result.append(repository, GitMergeOperation.this.rollback(repository));
                }
            }
        });
        preservingProcess.execute();
        LOG.info("Smart rollback completed.");
        return result;
    }

    private GitCommandResult rollback(GitRepository repository) {
        return this.myGit.reset(repository, GitResetMode.HARD, this.myCurrentRevisionsBeforeMerge.get(repository), new GitLineHandlerListener[0]);
    }

    private GitCommandResult rollbackMerge(GitRepository repository) {
        GitCommandResult result = this.myGit.resetMerge(repository, null);
        this.refresh(repository);
        return result;
    }

    private boolean thereAreLocalChangesIn(GitRepository repository) {
        return !this.myChangeListManager.getChangesIn(repository.getRoot()).isEmpty();
    }

    @Override
    public String getSuccessMessage() {
        return String.format("Merged <b><code>%s</code></b> to <b><code>%s</code></b>", this.myBranchToMerge, GitMergeOperation.stringifyBranchesByRepos(this.myCurrentHeads));
    }

    @Override
    protected String getRollbackProposal() {
        return "However merge has succeeded for the following " + this.repositories() + ":<br/>" + this.successfulRepositoriesJoined() + "<br/>" + ROLLBACK_PROPOSAL;
    }

    @Override
    protected String getOperationName() {
        return "merge";
    }

    private void refresh(GitRepository ... repositories) {
        for (GitRepository repository : repositories) {
            this.refreshRoot(repository);
            repository.update();
        }
    }

    private class DeleteMergedLocalBranchNotificationListener
    implements NotificationListener {
        private DeleteMergedLocalBranchNotificationListener() {
        }

        public void hyperlinkUpdate(Notification notification, HyperlinkEvent event) {
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && event.getDescription().equalsIgnoreCase("delete")) {
                GitBrancher brancher = (GitBrancher)ServiceManager.getService((Project)GitMergeOperation.this.myProject, GitBrancher.class);
                brancher.deleteBranch(GitMergeOperation.this.myBranchToMerge, new ArrayList<GitRepository>(GitMergeOperation.this.getRepositories()));
            }
        }
    }

    private class MyMergeConflictResolver
    extends GitMergeCommittingConflictResolver {
        public MyMergeConflictResolver() {
            super(GitMergeOperation.this.myProject, GitMergeOperation.this.myGit, new GitMerger(GitMergeOperation.this.myProject), GitUtil.getRootsFromRepositories(GitMergeOperation.this.myConflictedRepositories.keySet()), new GitConflictResolver.Params(), true);
        }

        @Override
        protected void notifyUnresolvedRemain() {
            VcsNotifier.getInstance((Project)this.myProject).notifyImportantWarning("Merged branch " + GitMergeOperation.this.myBranchToMerge + " with conflicts", "Unresolved conflicts remain in the project. <a href='resolve'>Resolve now.</a>", this.getResolveLinkListener());
        }
    }
}

