/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.ide.passwordSafe.MasterPasswordUnavailableException;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.ide.passwordSafe.PasswordSafeException;
import com.intellij.ide.passwordSafe.impl.PasswordSafeImpl;
import com.intellij.ide.passwordSafe.ui.PasswordSafePromptDialog;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.AuthData;
import com.intellij.util.UriUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.AuthDialog;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHttpAuthenticator;
import git4idea.remote.GitHttpAuthDataProvider;
import git4idea.remote.GitRememberedInputs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class GitHttpGuiAuthenticator
implements GitHttpAuthenticator {
    private static final Logger LOG = Logger.getInstance(GitHttpGuiAuthenticator.class);
    private static final Class<GitHttpAuthenticator> PASS_REQUESTER = GitHttpAuthenticator.class;
    private final Project myProject;
    private final String myTitle;
    private final String myUrlFromCommand;
    private String myPassword;
    private String myPasswordKey;
    private String myUrl;
    private String myLogin;
    private boolean mySaveOnDisk;
    private GitHttpAuthDataProvider myDataProvider;
    private boolean myWasCancelled;

    GitHttpGuiAuthenticator(Project project, GitCommand command, String url) {
        this.myProject = project;
        this.myTitle = "Git " + StringUtil.capitalize((String)command.name());
        this.myUrlFromCommand = url;
    }

    @Override
    public String askPassword(String url) {
        if (this.myPassword != null) {
            return this.myPassword;
        }
        if (this.myWasCancelled) {
            return "";
        }
        Pair<GitHttpAuthDataProvider, AuthData> authData = this.findBestAuthData(url = this.adjustUrl(url));
        if (authData != null && ((AuthData)authData.second).getPassword() != null) {
            String password = ((AuthData)authData.second).getPassword();
            this.myDataProvider = (GitHttpAuthDataProvider)authData.first;
            this.myPassword = password;
            return password;
        }
        String prompt = "Enter the password for " + url;
        this.myPasswordKey = url;
        String password = PasswordSafePromptDialog.askPassword((Project)this.myProject, (String)this.myTitle, (String)prompt, PASS_REQUESTER, (String)url, (boolean)false, null);
        if (password == null) {
            this.myWasCancelled = true;
            return "";
        }
        this.myPassword = password;
        this.myDataProvider = new GitDefaultHttpAuthDataProvider();
        return password;
    }

    @Override
    public String askUsername(String url) {
        url = this.adjustUrl(url);
        Pair<GitHttpAuthDataProvider, AuthData> authData = this.findBestAuthData(url);
        String login = null;
        String password = null;
        if (authData != null) {
            login = ((AuthData)authData.second).getLogin();
            password = ((AuthData)authData.second).getPassword();
            this.myDataProvider = (GitHttpAuthDataProvider)authData.first;
        }
        if (login != null && password != null) {
            this.myPassword = password;
            return login;
        }
        AuthDialog dialog = this.showAuthDialog(url, login);
        if (dialog == null || !dialog.isOK()) {
            this.myWasCancelled = true;
            return "";
        }
        this.myPassword = dialog.getPassword();
        this.myLogin = dialog.getUsername();
        this.myUrl = url;
        this.mySaveOnDisk = dialog.isRememberPassword();
        this.myPasswordKey = GitHttpGuiAuthenticator.makeKey(this.myUrl, this.myLogin);
        return this.myLogin;
    }

    private AuthDialog showAuthDialog(final String url, final String login) {
        final Ref dialog = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                dialog.set((Object)new AuthDialog(GitHttpGuiAuthenticator.this.myProject, GitHttpGuiAuthenticator.this.myTitle, "Enter credentials for " + url, login, null, true));
                ((AuthDialog)dialog.get()).show();
            }
        }, ModalityState.any());
        return (AuthDialog)dialog.get();
    }

    @Override
    public void saveAuthData() {
        if (this.myUrl != null && this.myLogin != null) {
            GitRememberedInputs.getInstance().addUrl(this.myUrl, this.myLogin);
        }
        if (this.myPasswordKey != null && this.myPassword != null) {
            PasswordSafeImpl passwordSafe = (PasswordSafeImpl)PasswordSafe.getInstance();
            try {
                passwordSafe.getMemoryProvider().storePassword(this.myProject, PASS_REQUESTER, this.myPasswordKey, this.myPassword);
                if (this.mySaveOnDisk) {
                    passwordSafe.getMasterKeyProvider().storePassword(this.myProject, PASS_REQUESTER, this.myPasswordKey, this.myPassword);
                }
            }
            catch (MasterPasswordUnavailableException ignored) {
            }
            catch (PasswordSafeException e) {
                LOG.error("Couldn't remember password for " + this.myPasswordKey, (Throwable)e);
            }
        }
    }

    @Override
    public void forgetPassword() {
        if (this.myDataProvider != null) {
            this.myDataProvider.forgetPassword(this.adjustUrl(this.myUrl));
        }
    }

    @Override
    public boolean wasCancelled() {
        return this.myWasCancelled;
    }

    private String adjustUrl(String url) {
        if (StringUtil.isEmptyOrSpaces((String)url)) {
            return GitHttpGuiAuthenticator.adjustHttpUrl(GitHttpGuiAuthenticator.getHost(this.myUrlFromCommand));
        }
        return GitHttpGuiAuthenticator.adjustHttpUrl(url);
    }

    private static String getHost(String url) {
        Couple split = UriUtil.splitScheme((String)url);
        String scheme = (String)split.getFirst();
        String urlItself = (String)split.getSecond();
        int pathStart = urlItself.indexOf("/");
        return scheme + "://" + urlItself.substring(0, pathStart);
    }

    private static String adjustHttpUrl(String url) {
        String prefix = "https";
        if (url.startsWith(prefix)) {
            return "http" + url.substring(prefix.length());
        }
        return url;
    }

    private Pair<GitHttpAuthDataProvider, AuthData> findBestAuthData(String url) {
        Pair candidate = null;
        for (GitHttpAuthDataProvider provider : this.getProviders()) {
            AuthData data = provider.getAuthData(url);
            if (data == null) continue;
            Pair pair = Pair.create((Object)provider, (Object)data);
            if (data.getPassword() != null) {
                return pair;
            }
            if (candidate != null) continue;
            candidate = pair;
        }
        return candidate;
    }

    private List<GitHttpAuthDataProvider> getProviders() {
        ArrayList providers = ContainerUtil.newArrayList();
        providers.add(new GitDefaultHttpAuthDataProvider());
        providers.addAll(Arrays.asList(GitHttpAuthDataProvider.EP_NAME.getExtensions()));
        return providers;
    }

    private static String makeKey(String url, String login) {
        if (login == null) {
            return url;
        }
        Couple pair = UriUtil.splitScheme((String)url);
        String scheme = (String)pair.getFirst();
        if (StringUtil.isEmpty((String)scheme)) {
            return scheme + "://" + login + "@" + (String)pair.getSecond();
        }
        return login + "@" + url;
    }

    public class GitDefaultHttpAuthDataProvider
    implements GitHttpAuthDataProvider {
        @Override
        public AuthData getAuthData(String url) {
            String userName = this.getUsername(url);
            String key = GitHttpGuiAuthenticator.makeKey(url, userName);
            PasswordSafe passwordSafe = PasswordSafe.getInstance();
            try {
                String password = passwordSafe.getPassword(GitHttpGuiAuthenticator.this.myProject, PASS_REQUESTER, key);
                return new AuthData(StringUtil.notNullize((String)userName), password);
            }
            catch (PasswordSafeException e) {
                LOG.info("Couldn't get the password for key [" + key + "]", (Throwable)e);
                return null;
            }
        }

        private String getUsername(String url) {
            return GitRememberedInputs.getInstance().getUserNameForUrl(url);
        }

        @Override
        public void forgetPassword(String url) {
            String key = GitHttpGuiAuthenticator.this.myPasswordKey != null ? GitHttpGuiAuthenticator.this.myPasswordKey : GitHttpGuiAuthenticator.makeKey(url, this.getUsername(url));
            try {
                PasswordSafe.getInstance().removePassword(GitHttpGuiAuthenticator.this.myProject, PASS_REQUESTER, key);
            }
            catch (PasswordSafeException e) {
                LOG.info("Couldn't forget the password for " + GitHttpGuiAuthenticator.this.myPasswordKey);
            }
        }
    }
}

