/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.commands.GitLineHandlerListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class GitMessageWithFilesDetector
implements GitLineHandlerListener {
    private final Event myEvent;
    private final VirtualFile myRoot;
    protected final Set<String> myAffectedFiles = new HashSet<String>();
    protected boolean myMessageDetected;
    private boolean myFilesAreDisplayed;

    public GitMessageWithFilesDetector(Event event, VirtualFile root) {
        this.myEvent = event;
        this.myRoot = root;
    }

    @Override
    public void onLineAvailable(String line, Key outputType) {
        if (line.contains(this.myEvent.getMessageStartMarker())) {
            this.myMessageDetected = true;
            this.myFilesAreDisplayed = true;
        } else if (line.contains(this.myEvent.getMessageEndMarker())) {
            this.myFilesAreDisplayed = false;
        } else if (this.myFilesAreDisplayed) {
            this.myAffectedFiles.add(line.trim());
        }
    }

    public void processTerminated(int exitCode) {
    }

    public void startFailed(Throwable exception) {
    }

    public boolean wasMessageDetected() {
        return this.myMessageDetected;
    }

    public Set<String> getRelativeFilePaths() {
        return this.myAffectedFiles;
    }

    public Collection<VirtualFile> getFiles() {
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(this.myAffectedFiles.size());
        for (String affectedFile : this.myAffectedFiles) {
            VirtualFile file = this.myRoot.findFileByRelativePath(FileUtil.toSystemIndependentName((String)affectedFile));
            if (file == null) continue;
            files.add(file);
        }
        return files;
    }

    public static class Event {
        private final String myMessageStartMarker;
        private final String myMessageEndMarker;

        Event(String messageStartMarker, String messageEndMarker) {
            this.myMessageStartMarker = messageStartMarker;
            this.myMessageEndMarker = messageEndMarker;
        }

        public String getMessageStartMarker() {
            return this.myMessageStartMarker;
        }

        public String getMessageEndMarker() {
            return this.myMessageEndMarker;
        }
    }
}

