/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import git4idea.GitBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitStandardRemoteBranch;
import git4idea.GitUtil;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.UpdateMethod;
import git4idea.push.GitPushTagMode;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.reset.GitResetMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@com.intellij.openapi.components.State(name="Git.Settings", storages={@Storage(file="$WORKSPACE_FILE$")})
public class GitVcsSettings
implements PersistentStateComponent<State>,
DvcsSyncSettings {
    private static final int PREVIOUS_COMMIT_AUTHORS_LIMIT = 16;
    private final GitVcsApplicationSettings myAppSettings;
    private State myState = new State();

    public GitVcsSettings(GitVcsApplicationSettings appSettings) {
        this.myAppSettings = appSettings;
    }

    public GitVcsApplicationSettings getAppSettings() {
        return this.myAppSettings;
    }

    public static GitVcsSettings getInstance(Project project) {
        return (GitVcsSettings)PeriodicalTasksCloser.getInstance().safeGetService(project, GitVcsSettings.class);
    }

    public UpdateMethod getUpdateType() {
        return (UpdateMethod)((Object)ObjectUtils.notNull((Object)((Object)this.myState.UPDATE_TYPE), (Object)((Object)UpdateMethod.BRANCH_DEFAULT)));
    }

    public void setUpdateType(UpdateMethod updateType) {
        this.myState.UPDATE_TYPE = updateType;
    }

    public UpdateChangesPolicy updateChangesPolicy() {
        return this.myState.UPDATE_CHANGES_POLICY;
    }

    public void setUpdateChangesPolicy(UpdateChangesPolicy value) {
        this.myState.UPDATE_CHANGES_POLICY = value;
    }

    public void saveCommitAuthor(String author) {
        this.myState.PREVIOUS_COMMIT_AUTHORS.remove(author);
        while (this.myState.PREVIOUS_COMMIT_AUTHORS.size() >= 16) {
            this.myState.PREVIOUS_COMMIT_AUTHORS.remove(this.myState.PREVIOUS_COMMIT_AUTHORS.size() - 1);
        }
        this.myState.PREVIOUS_COMMIT_AUTHORS.add(0, author);
    }

    public String[] getCommitAuthors() {
        return ArrayUtil.toStringArray(this.myState.PREVIOUS_COMMIT_AUTHORS);
    }

    public State getState() {
        return this.myState;
    }

    public void loadState(State state) {
        this.myState = state;
    }

    public boolean autoUpdateIfPushRejected() {
        return this.myState.PUSH_AUTO_UPDATE;
    }

    public void setAutoUpdateIfPushRejected(boolean autoUpdate) {
        this.myState.PUSH_AUTO_UPDATE = autoUpdate;
    }

    public boolean shouldUpdateAllRootsIfPushRejected() {
        return this.myState.PUSH_UPDATE_ALL_ROOTS;
    }

    public void setUpdateAllRootsIfPushRejected(boolean updateAllRoots) {
        this.myState.PUSH_UPDATE_ALL_ROOTS = updateAllRoots;
    }

    public DvcsSyncSettings.Value getSyncSetting() {
        return this.myState.ROOT_SYNC;
    }

    public void setSyncSetting(DvcsSyncSettings.Value syncSetting) {
        this.myState.ROOT_SYNC = syncSetting;
    }

    public String getRecentRootPath() {
        return this.myState.RECENT_GIT_ROOT_PATH;
    }

    public void setRecentRoot(String recentGitRootPath) {
        this.myState.RECENT_GIT_ROOT_PATH = recentGitRootPath;
    }

    public Map<String, String> getRecentBranchesByRepository() {
        return this.myState.RECENT_BRANCH_BY_REPOSITORY;
    }

    public void setRecentBranchOfRepository(String repositoryPath, String branch) {
        this.myState.RECENT_BRANCH_BY_REPOSITORY.put(repositoryPath, branch);
    }

    public String getRecentCommonBranch() {
        return this.myState.RECENT_COMMON_BRANCH;
    }

    public void setRecentCommonBranch(String branch) {
        this.myState.RECENT_COMMON_BRANCH = branch;
    }

    public void setAutoCommitOnCherryPick(boolean autoCommit) {
        this.myState.AUTO_COMMIT_ON_CHERRY_PICK = autoCommit;
    }

    public boolean isAutoCommitOnCherryPick() {
        return this.myState.AUTO_COMMIT_ON_CHERRY_PICK;
    }

    public boolean warnAboutCrlf() {
        return this.myState.WARN_ABOUT_CRLF;
    }

    public void setWarnAboutCrlf(boolean warn) {
        this.myState.WARN_ABOUT_CRLF = warn;
    }

    public boolean warnAboutDetachedHead() {
        return this.myState.WARN_ABOUT_DETACHED_HEAD;
    }

    public void setWarnAboutDetachedHead(boolean warn) {
        this.myState.WARN_ABOUT_DETACHED_HEAD = warn;
    }

    public GitResetMode getResetMode() {
        return this.myState.RESET_MODE;
    }

    public void setResetMode(GitResetMode mode) {
        this.myState.RESET_MODE = mode;
    }

    public boolean isForcePushAllowed() {
        return this.myState.FORCE_PUSH_ALLOWED;
    }

    public void setForcePushAllowed(boolean allowed) {
        this.myState.FORCE_PUSH_ALLOWED = allowed;
    }

    public GitPushTagMode getPushTagMode() {
        return this.myState.PUSH_TAGS;
    }

    public void setPushTagMode(GitPushTagMode mode) {
        this.myState.PUSH_TAGS = mode;
    }

    @Deprecated
    public boolean isIdeaSsh() {
        if (this.getAppSettings().getIdeaSsh() == null) {
            this.getAppSettings().setIdeaSsh(this.myState.SSH_EXECUTABLE);
        }
        return this.getAppSettings().getIdeaSsh() == GitVcsApplicationSettings.SshExecutable.IDEA_SSH;
    }

    public GitRemoteBranch getPushTarget(GitRepository repository, String sourceBranch) {
        Iterator<PushTargetInfo> iterator = this.myState.PUSH_TARGETS.iterator();
        PushTargetInfo targetInfo = GitVcsSettings.find(iterator, repository, sourceBranch);
        if (targetInfo == null) {
            return null;
        }
        GitRemote remote = GitUtil.findRemoteByName(repository, targetInfo.targetRemoteName);
        if (remote == null) {
            return null;
        }
        GitRemoteBranch remoteBranch = GitUtil.findRemoteBranch(repository, remote, targetInfo.targetBranchName);
        return (GitRemoteBranch)ObjectUtils.notNull((Object)remoteBranch, (Object)new GitStandardRemoteBranch(remote, targetInfo.targetBranchName, GitBranch.DUMMY_HASH));
    }

    public void setPushTarget(GitRepository repository, String sourceBranch, String targetRemote, String targetBranch) {
        String repositoryPath = repository.getRoot().getPath();
        ArrayList<PushTargetInfo> targets = new ArrayList<PushTargetInfo>(this.myState.PUSH_TARGETS);
        Iterator<PushTargetInfo> iterator = targets.iterator();
        PushTargetInfo existingInfo = GitVcsSettings.find(iterator, repository, sourceBranch);
        if (existingInfo != null) {
            iterator.remove();
        }
        PushTargetInfo newInfo = new PushTargetInfo(repositoryPath, sourceBranch, targetRemote, targetBranch);
        targets.add(newInfo);
        this.myState.PUSH_TARGETS = targets;
    }

    private static PushTargetInfo find(Iterator<PushTargetInfo> iterator, GitRepository repository, String sourceBranch) {
        while (iterator.hasNext()) {
            PushTargetInfo targetInfo = iterator.next();
            if (!targetInfo.repoPath.equals(repository.getRoot().getPath()) || !targetInfo.sourceName.equals(sourceBranch)) continue;
            return targetInfo;
        }
        return null;
    }

    @Tag(value="push-target-info")
    private static class PushTargetInfo {
        @Attribute(value="repo")
        public String repoPath;
        @Attribute(value="source")
        public String sourceName;
        @Attribute(value="target-remote")
        public String targetRemoteName;
        @Attribute(value="target-branch")
        public String targetBranchName;

        public PushTargetInfo() {
            this("", "", "", "");
        }

        PushTargetInfo(String repositoryPath, String source, String targetRemote, String targetBranch) {
            this.repoPath = repositoryPath;
            this.sourceName = source;
            this.targetRemoteName = targetRemote;
            this.targetBranchName = targetBranch;
        }
    }

    public static class State {
        public List<String> PREVIOUS_COMMIT_AUTHORS = new ArrayList<String>();
        public GitVcsApplicationSettings.SshExecutable SSH_EXECUTABLE = GitVcsApplicationSettings.SshExecutable.IDEA_SSH;
        public UpdateChangesPolicy UPDATE_CHANGES_POLICY = UpdateChangesPolicy.STASH;
        public UpdateMethod UPDATE_TYPE = UpdateMethod.BRANCH_DEFAULT;
        public boolean PUSH_AUTO_UPDATE = false;
        public boolean PUSH_UPDATE_ALL_ROOTS = true;
        public DvcsSyncSettings.Value ROOT_SYNC = DvcsSyncSettings.Value.NOT_DECIDED;
        public String RECENT_GIT_ROOT_PATH = null;
        public Map<String, String> RECENT_BRANCH_BY_REPOSITORY = new HashMap<String, String>();
        public String RECENT_COMMON_BRANCH = null;
        public boolean AUTO_COMMIT_ON_CHERRY_PICK = false;
        public boolean WARN_ABOUT_CRLF = true;
        public boolean WARN_ABOUT_DETACHED_HEAD = true;
        public GitResetMode RESET_MODE = null;
        public boolean FORCE_PUSH_ALLOWED = false;
        public GitPushTagMode PUSH_TAGS = null;
        @AbstractCollection(surroundWithTag=false)
        @Tag(value="push-targets")
        public List<PushTargetInfo> PUSH_TARGETS = ContainerUtil.newArrayList();
    }

    public static enum UpdateChangesPolicy {
        STASH,
        SHELVE;

    }
}

