/*
 * Decompiled with CFR 0.152.
 */
package git4idea.crlf;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitPlatformFacade;
import git4idea.GitUtil;
import git4idea.attributes.GitAttribute;
import git4idea.attributes.GitCheckAttrParser;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GitCrlfProblemsDetector {
    private static final Logger LOG = Logger.getInstance(GitCrlfProblemsDetector.class);
    private static final String CRLF = "\r\n";
    private final Project myProject;
    private final GitPlatformFacade myPlatformFacade;
    private final Git myGit;
    private final boolean myShouldWarn;

    public static GitCrlfProblemsDetector detect(Project project, GitPlatformFacade platformFacade, Git git, Collection<VirtualFile> files) {
        return new GitCrlfProblemsDetector(project, platformFacade, git, files);
    }

    private GitCrlfProblemsDetector(Project project, GitPlatformFacade platformFacade, Git git, Collection<VirtualFile> files) {
        Map<VirtualFile, Collection<VirtualFile>> crlfFilesByRoots;
        this.myProject = project;
        this.myPlatformFacade = platformFacade;
        this.myGit = git;
        Map<VirtualFile, List<VirtualFile>> filesByRoots = GitCrlfProblemsDetector.sortFilesByRoots(files);
        boolean shouldWarn = false;
        Collection<VirtualFile> rootsWithIncorrectAutoCrlf = this.getRootsWithIncorrectAutoCrlf(filesByRoots);
        if (!rootsWithIncorrectAutoCrlf.isEmpty() && !(crlfFilesByRoots = this.findFilesWithCrlf(filesByRoots, rootsWithIncorrectAutoCrlf)).isEmpty()) {
            Map<VirtualFile, Collection<VirtualFile>> crlfFilesWithoutAttrsByRoots = this.findFilesWithoutAttrs(crlfFilesByRoots);
            shouldWarn = !crlfFilesWithoutAttrsByRoots.isEmpty();
        }
        this.myShouldWarn = shouldWarn;
    }

    private Map<VirtualFile, Collection<VirtualFile>> findFilesWithoutAttrs(Map<VirtualFile, Collection<VirtualFile>> filesByRoots) {
        HashMap<VirtualFile, Collection<VirtualFile>> filesWithoutAttrsByRoot = new HashMap<VirtualFile, Collection<VirtualFile>>();
        for (Map.Entry<VirtualFile, Collection<VirtualFile>> entry : filesByRoots.entrySet()) {
            Collection<VirtualFile> files;
            VirtualFile root = entry.getKey();
            Collection<VirtualFile> filesWithoutAttrs = this.findFilesWithoutAttrs(root, files = entry.getValue());
            if (filesWithoutAttrs.isEmpty()) continue;
            filesWithoutAttrsByRoot.put(root, filesWithoutAttrs);
        }
        return filesWithoutAttrsByRoot;
    }

    private Collection<VirtualFile> findFilesWithoutAttrs(VirtualFile root, Collection<VirtualFile> files) {
        GitRepository repository = (GitRepository)this.myPlatformFacade.getRepositoryManager(this.myProject).getRepositoryForRoot(root);
        if (repository == null) {
            LOG.warn("Repository is null for " + root);
            return Collections.emptyList();
        }
        List<String> interestingAttributes = Arrays.asList(GitAttribute.TEXT.getName(), GitAttribute.CRLF.getName());
        GitCommandResult result = this.myGit.checkAttr(repository, interestingAttributes, files);
        if (!result.success()) {
            LOG.warn(String.format("Couldn't git check-attr. Attributes: %s, files: %s", interestingAttributes, files));
            return Collections.emptyList();
        }
        GitCheckAttrParser parser = GitCheckAttrParser.parse(result.getOutput());
        Map<String, Collection<GitAttribute>> attributes = parser.getAttributes();
        ArrayList<VirtualFile> filesWithoutAttrs = new ArrayList<VirtualFile>();
        for (VirtualFile file : files) {
            ProgressIndicatorProvider.checkCanceled();
            String relativePath = FileUtil.getRelativePath((String)root.getPath(), (String)file.getPath(), (char)'/');
            Collection<GitAttribute> attrs = attributes.get(relativePath);
            if (attrs != null && (attrs.contains((Object)GitAttribute.TEXT) || attrs.contains((Object)GitAttribute.CRLF))) continue;
            filesWithoutAttrs.add(file);
        }
        return filesWithoutAttrs;
    }

    private Map<VirtualFile, Collection<VirtualFile>> findFilesWithCrlf(Map<VirtualFile, List<VirtualFile>> allFilesByRoots, Collection<VirtualFile> rootsWithIncorrectAutoCrlf) {
        HashMap<VirtualFile, Collection<VirtualFile>> filesWithCrlfByRoots = new HashMap<VirtualFile, Collection<VirtualFile>>();
        for (Map.Entry<VirtualFile, List<VirtualFile>> entry : allFilesByRoots.entrySet()) {
            Collection<VirtualFile> filesWithCrlf;
            VirtualFile root = entry.getKey();
            List<VirtualFile> files = entry.getValue();
            if (!rootsWithIncorrectAutoCrlf.contains(root) || (filesWithCrlf = this.findFilesWithCrlf(files)).isEmpty()) continue;
            filesWithCrlfByRoots.put(root, filesWithCrlf);
        }
        return filesWithCrlfByRoots;
    }

    private Collection<VirtualFile> findFilesWithCrlf(Collection<VirtualFile> files) {
        ArrayList<VirtualFile> filesWithCrlf = new ArrayList<VirtualFile>();
        for (VirtualFile file : files) {
            ProgressIndicatorProvider.checkCanceled();
            String separator = this.myPlatformFacade.getLineSeparator(file, true);
            if (!CRLF.equals(separator)) continue;
            filesWithCrlf.add(file);
        }
        return filesWithCrlf;
    }

    private Collection<VirtualFile> getRootsWithIncorrectAutoCrlf(Map<VirtualFile, List<VirtualFile>> filesByRoots) {
        ArrayList<VirtualFile> rootsWithIncorrectAutoCrlf = new ArrayList<VirtualFile>();
        for (Map.Entry<VirtualFile, List<VirtualFile>> entry : filesByRoots.entrySet()) {
            VirtualFile root = entry.getKey();
            boolean autocrlf = this.isAutoCrlfSetRight(root);
            if (autocrlf) continue;
            rootsWithIncorrectAutoCrlf.add(root);
        }
        return rootsWithIncorrectAutoCrlf;
    }

    private boolean isAutoCrlfSetRight(VirtualFile root) {
        GitRepository repository = (GitRepository)this.myPlatformFacade.getRepositoryManager(this.myProject).getRepositoryForRoot(root);
        if (repository == null) {
            LOG.warn("Repository is null for " + root);
            return true;
        }
        GitCommandResult result = this.myGit.config(repository, "core.autocrlf");
        String value = result.getOutputAsJoinedString();
        return value.equalsIgnoreCase("true") || value.equalsIgnoreCase("input");
    }

    private static Map<VirtualFile, List<VirtualFile>> sortFilesByRoots(Collection<VirtualFile> files) {
        return GitUtil.sortFilesByGitRootsIgnoringOthers(files);
    }

    public boolean shouldWarn() {
        return this.myShouldWarn;
    }
}

