/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.BaseDiffFromHistoryHandler;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitFileRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.changes.GitChangeUtils;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class GitDiffFromHistoryHandler
extends BaseDiffFromHistoryHandler<GitFileRevision> {
    private static final Logger LOG = Logger.getInstance(GitDiffFromHistoryHandler.class);
    private final Git myGit;
    private final GitRepositoryManager myRepositoryManager;

    public GitDiffFromHistoryHandler(Project project) {
        super(project);
        this.myGit = (Git)ServiceManager.getService((Project)project, Git.class);
        this.myRepositoryManager = GitUtil.getRepositoryManager(project);
    }

    public void showDiffForOne(AnActionEvent e, Project project, FilePath filePath, VcsFileRevision previousRevision, VcsFileRevision revision) {
        GitFileRevision rev = (GitFileRevision)revision;
        Collection<String> parents = rev.getParents();
        if (parents.size() < 2) {
            super.showDiffForOne(e, project, filePath, previousRevision, revision);
        } else {
            this.showDiffForMergeCommit(e, filePath, rev, parents);
        }
    }

    protected List<Change> getChangesBetweenRevisions(FilePath path, GitFileRevision rev1, GitFileRevision rev2) throws VcsException {
        GitRepository repository = this.getRepository(path);
        String hash1 = rev1.getHash();
        String hash2 = rev2 != null ? rev2.getHash() : null;
        return ContainerUtil.newArrayList(GitChangeUtils.getDiff(repository.getProject(), repository.getRoot(), hash1, hash2, Collections.singletonList(path)));
    }

    protected List<Change> getAffectedChanges(FilePath path, GitFileRevision rev) throws VcsException {
        GitRepository repository = this.getRepository(path);
        return ContainerUtil.newArrayList((Iterable)GitChangeUtils.getRevisionChanges(repository.getProject(), repository.getRoot(), rev.getHash(), false, true, true).getChanges());
    }

    protected String getPresentableName(GitFileRevision revision) {
        return DvcsUtil.getShortHash((String)revision.getHash());
    }

    private GitRepository getRepository(FilePath path) {
        GitRepository repository = (GitRepository)this.myRepositoryManager.getRepositoryForFile(path);
        LOG.assertTrue(repository != null, (Object)("Repository is null for " + path));
        return repository;
    }

    private void showDiffForMergeCommit(final AnActionEvent event, final FilePath filePath, final GitFileRevision rev, Collection<String> parents) {
        this.checkIfFileWasTouchedAndFindParentsInBackground(filePath, rev, parents, new Consumer<MergeCommitPreCheckInfo>(){

            public void consume(MergeCommitPreCheckInfo info) {
                if (!info.wasFileTouched()) {
                    String message = String.format("There were no changes in %s in this merge commit, besides those which were made in both branches", filePath.getName());
                    VcsBalloonProblemNotifier.showOverVersionControlView((Project)GitDiffFromHistoryHandler.this.myProject, (String)message, (MessageType)MessageType.INFO);
                }
                GitDiffFromHistoryHandler.this.showPopup(event, rev, filePath, info.getParents());
            }
        });
    }

    private void checkIfFileWasTouchedAndFindParentsInBackground(final FilePath filePath, final GitFileRevision rev, final Collection<String> parentHashes, final Consumer<MergeCommitPreCheckInfo> resultHandler) {
        new Task.Backgroundable(this.myProject, "Loading changes...", false){
            private MergeCommitPreCheckInfo myInfo;

            public void run(ProgressIndicator indicator) {
                try {
                    GitRepository repository = GitDiffFromHistoryHandler.this.getRepository(filePath);
                    boolean fileTouched = GitDiffFromHistoryHandler.this.wasFileTouched(repository, rev);
                    Collection parents = GitDiffFromHistoryHandler.this.findParentRevisions(repository, rev, parentHashes);
                    this.myInfo = new MergeCommitPreCheckInfo(fileTouched, parents);
                }
                catch (VcsException e) {
                    String logMessage = "Error happened while executing git show " + rev + ":" + filePath;
                    GitDiffFromHistoryHandler.this.showError(e, logMessage);
                }
            }

            public void onSuccess() {
                if (this.myInfo != null) {
                    resultHandler.consume((Object)this.myInfo);
                }
            }
        }.queue();
    }

    private Collection<GitFileRevision> findParentRevisions(GitRepository repository, GitFileRevision currentRevision, Collection<String> parentHashes) throws VcsException {
        ArrayList<GitFileRevision> parents = new ArrayList<GitFileRevision>(parentHashes.size());
        for (String parentHash : parentHashes) {
            parents.add(this.createParentRevision(repository, currentRevision, parentHash));
        }
        return parents;
    }

    private GitFileRevision createParentRevision(GitRepository repository, GitFileRevision currentRevision, String parentHash) throws VcsException {
        FilePath currentRevisionPath = currentRevision.getPath();
        if (currentRevisionPath.isDirectory()) {
            return this.makeRevisionFromHash(currentRevisionPath, parentHash);
        }
        Collection<Change> changes = GitChangeUtils.getDiff(this.myProject, repository.getRoot(), parentHash, currentRevision.getHash(), null);
        for (Change change : changes) {
            ContentRevision afterRevision = change.getAfterRevision();
            ContentRevision beforeRevision = change.getBeforeRevision();
            if (afterRevision == null || !afterRevision.getFile().equals(currentRevisionPath)) continue;
            FilePath path = beforeRevision != null ? beforeRevision.getFile() : afterRevision.getFile();
            return new GitFileRevision(this.myProject, path, new GitRevisionNumber(parentHash));
        }
        LOG.error(String.format("Could not find parent revision. Will use the path from parent revision. Current revision: %s, parent hash: %s", currentRevision, parentHash));
        return this.makeRevisionFromHash(currentRevisionPath, parentHash);
    }

    private void showPopup(AnActionEvent event, GitFileRevision rev, FilePath filePath, Collection<GitFileRevision> parents) {
        ActionGroup parentActions = this.createActionGroup(rev, filePath, parents);
        DataContext dataContext = SimpleDataContext.getProjectContext((Project)this.myProject);
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup("Choose parent to compare", parentActions, dataContext, JBPopupFactory.ActionSelectionAid.NUMBERING, true);
        GitDiffFromHistoryHandler.showPopupInBestPosition(popup, event, dataContext);
    }

    private static void showPopupInBestPosition(ListPopup popup, AnActionEvent event, DataContext dataContext) {
        if (event.getInputEvent() instanceof MouseEvent) {
            if (!event.getPlace().equals("UpdatePopup")) {
                popup.show(new RelativePoint((MouseEvent)event.getInputEvent()));
            } else {
                popup.showInBestPositionFor(dataContext);
            }
        } else {
            popup.showInBestPositionFor(dataContext);
        }
    }

    private ActionGroup createActionGroup(GitFileRevision rev, FilePath filePath, Collection<GitFileRevision> parents) {
        ArrayList<AnAction> actions = new ArrayList<AnAction>(2);
        for (GitFileRevision parent : parents) {
            actions.add(this.createParentAction(rev, filePath, parent));
        }
        return new DefaultActionGroup((AnAction[])ArrayUtil.toObjectArray(actions, AnAction.class));
    }

    private AnAction createParentAction(GitFileRevision rev, FilePath filePath, GitFileRevision parent) {
        return new ShowDiffWithParentAction(filePath, rev, parent);
    }

    private GitFileRevision makeRevisionFromHash(FilePath filePath, String hash) {
        return new GitFileRevision(this.myProject, filePath, new GitRevisionNumber(hash));
    }

    private boolean wasFileTouched(GitRepository repository, GitFileRevision rev) throws VcsException {
        GitCommandResult result = this.myGit.show(repository, rev.getHash());
        if (result.success()) {
            return GitDiffFromHistoryHandler.isFilePresentInOutput(repository, rev.getPath(), result.getOutput());
        }
        throw new VcsException(result.getErrorOutputAsJoinedString());
    }

    private static boolean isFilePresentInOutput(GitRepository repository, FilePath path, List<String> output) {
        String relativePath = GitDiffFromHistoryHandler.getRelativePath(repository, path);
        for (String line : output) {
            if (!line.startsWith("---") && !line.startsWith("+++") || !line.contains(relativePath)) continue;
            return true;
        }
        return false;
    }

    private static String getRelativePath(GitRepository repository, FilePath path) {
        return FileUtil.getRelativePath((String)repository.getRoot().getPath(), (String)path.getPath(), (char)'/');
    }

    private class ShowDiffWithParentAction
    extends AnAction {
        private final FilePath myFilePath;
        private final GitFileRevision myRevision;
        private final GitFileRevision myParentRevision;

        public ShowDiffWithParentAction(FilePath filePath, GitFileRevision rev, GitFileRevision parent) {
            super(DvcsUtil.getShortHash((String)parent.getHash()));
            this.myFilePath = filePath;
            this.myRevision = rev;
            this.myParentRevision = parent;
        }

        public void actionPerformed(AnActionEvent e) {
            GitDiffFromHistoryHandler.this.doShowDiff(this.myFilePath, (VcsFileRevision)this.myParentRevision, (VcsFileRevision)this.myRevision, false);
        }
    }

    private static class MergeCommitPreCheckInfo {
        private final boolean myWasFileTouched;
        private final Collection<GitFileRevision> myParents;

        private MergeCommitPreCheckInfo(boolean touched, Collection<GitFileRevision> parents) {
            this.myWasFileTouched = touched;
            this.myParents = parents;
        }

        public boolean wasFileTouched() {
            return this.myWasFileTouched;
        }

        public Collection<GitFileRevision> getParents() {
            return this.myParents;
        }
    }
}

