/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.RefGroup;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import com.intellij.vcs.log.impl.SingletonRefGroup;
import com.intellij.vcs.log.impl.VcsLogUtil;
import git4idea.GitBranch;
import git4idea.GitRemoteBranch;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GitRefManager
implements VcsLogRefManager {
    private static final Color HEAD_COLOR = new JBColor(new Color(15855518), new Color(113, 111, 64));
    private static final Color LOCAL_BRANCH_COLOR = new JBColor(new Color(7728839), new Color(879951));
    private static final Color REMOTE_BRANCH_COLOR = new JBColor(new Color(0xBCBCFC), new Color(0xBCBCFC).darker().darker());
    private static final Color TAG_COLOR = JBColor.WHITE;
    public static final VcsRefType HEAD = new SimpleRefType(true, HEAD_COLOR);
    public static final VcsRefType LOCAL_BRANCH = new SimpleRefType(true, LOCAL_BRANCH_COLOR);
    public static final VcsRefType REMOTE_BRANCH = new SimpleRefType(true, REMOTE_BRANCH_COLOR);
    public static final VcsRefType TAG = new SimpleRefType(false, TAG_COLOR);
    public static final VcsRefType OTHER = new SimpleRefType(false, TAG_COLOR);
    private static final String MASTER = "master";
    private static final String ORIGIN_MASTER = "origin/master";
    private static final Logger LOG = Logger.getInstance(GitRefManager.class);
    private final RepositoryManager<GitRepository> myRepositoryManager;
    private final Comparator<VcsRef> myLabelsComparator;
    private final Comparator<VcsRef> myBranchLayoutComparator;

    public GitRefManager(RepositoryManager<GitRepository> repositoryManager) {
        this.myRepositoryManager = repositoryManager;
        this.myBranchLayoutComparator = new GitBranchLayoutComparator(repositoryManager);
        this.myLabelsComparator = new GitLabelComparator(repositoryManager);
    }

    public Comparator<VcsRef> getLabelsOrderComparator() {
        return this.myLabelsComparator;
    }

    public Comparator<VcsRef> getBranchLayoutComparator() {
        return this.myBranchLayoutComparator;
    }

    public List<RefGroup> group(Collection<VcsRef> refs) {
        ArrayList simpleGroups = ContainerUtil.newArrayList();
        ArrayList localBranches = ContainerUtil.newArrayList();
        ArrayList trackedBranches = ContainerUtil.newArrayList();
        MultiMap remoteRefGroups = MultiMap.create();
        MultiMap<VirtualFile, VcsRef> refsByRoot = GitRefManager.groupRefsByRoot(refs);
        for (Map.Entry entry : refsByRoot.entrySet()) {
            VirtualFile root = (VirtualFile)entry.getKey();
            Collection refsInRoot = (Collection)entry.getValue();
            GitRepository repository = (GitRepository)this.myRepositoryManager.getRepositoryForRoot(root);
            if (repository == null) {
                LOG.warn("No repository for root: " + root);
                continue;
            }
            Set<String> locals = GitRefManager.getLocalBranches(repository);
            Set<String> tracked = GitRefManager.getTrackedRemoteBranches(repository);
            Map<String, GitRemote> allRemote = GitRefManager.getAllRemoteBranches(repository);
            for (VcsRef ref : refsInRoot) {
                if (ref.getType() == HEAD) {
                    simpleGroups.add(new SingletonRefGroup(ref));
                    continue;
                }
                String refName = ref.getName();
                if (locals.contains(refName)) {
                    localBranches.add(ref);
                    continue;
                }
                if (allRemote.containsKey(refName)) {
                    remoteRefGroups.putValue((Object)allRemote.get(refName), (Object)ref);
                    if (!tracked.contains(refName)) continue;
                    trackedBranches.add(ref);
                    continue;
                }
                LOG.debug("Didn't find ref neither in local nor in remote branches: " + ref);
            }
        }
        ArrayList result = ContainerUtil.newArrayList();
        result.addAll(simpleGroups);
        result.add(new LogicalRefGroup("Local", localBranches));
        result.add(new LogicalRefGroup("Tracked", trackedBranches));
        for (Map.Entry entry : remoteRefGroups.entrySet()) {
            GitRemote remote = (GitRemote)entry.getKey();
            Collection branches = (Collection)entry.getValue();
            result.add(new RemoteRefGroup(remote, branches));
        }
        return result;
    }

    private static Set<String> getLocalBranches(GitRepository repository) {
        return ContainerUtil.map2Set(repository.getBranches().getLocalBranches(), (Function)new Function<GitBranch, String>(){

            public String fun(GitBranch branch) {
                return branch.getName();
            }
        });
    }

    private static Set<String> getTrackedRemoteBranches(GitRepository repository) {
        HashSet<GitRemoteBranch> all = new HashSet<GitRemoteBranch>(repository.getBranches().getRemoteBranches());
        HashSet<String> tracked = new HashSet<String>();
        for (GitBranchTrackInfo info : repository.getBranchTrackInfos()) {
            GitRemoteBranch trackedRemoteBranch = info.getRemoteBranch();
            if (!all.contains(trackedRemoteBranch)) continue;
            tracked.add(trackedRemoteBranch.getName());
        }
        return tracked;
    }

    private static Map<String, GitRemote> getAllRemoteBranches(GitRepository repository) {
        HashSet<GitRemoteBranch> all = new HashSet<GitRemoteBranch>(repository.getBranches().getRemoteBranches());
        HashMap allRemote = ContainerUtil.newHashMap();
        for (GitRemoteBranch remoteBranch : all) {
            allRemote.put(remoteBranch.getName(), remoteBranch.getRemote());
        }
        return allRemote;
    }

    private static Set<String> getTrackedRemoteBranchesFromConfig(GitRepository repository) {
        return ContainerUtil.map2Set(repository.getBranchTrackInfos(), (Function)new Function<GitBranchTrackInfo, String>(){

            public String fun(GitBranchTrackInfo trackInfo) {
                return trackInfo.getRemoteBranch().getName();
            }
        });
    }

    private static MultiMap<VirtualFile, VcsRef> groupRefsByRoot(Iterable<VcsRef> refs) {
        MultiMap grouped = MultiMap.create();
        for (VcsRef ref : refs) {
            grouped.putValue((Object)ref.getRoot(), (Object)ref);
        }
        return grouped;
    }

    public static VcsRefType getRefType(String refName) {
        if (refName.startsWith("refs/heads/")) {
            return LOCAL_BRANCH;
        }
        if (refName.startsWith("refs/remotes/")) {
            return REMOTE_BRANCH;
        }
        if (refName.startsWith("refs/tags/")) {
            return TAG;
        }
        if (refName.startsWith("HEAD")) {
            return HEAD;
        }
        return OTHER;
    }

    private static abstract class GitRefComparator
    implements Comparator<VcsRef> {
        private final RepositoryManager<GitRepository> myRepositoryManager;

        GitRefComparator(RepositoryManager<GitRepository> repositoryManager) {
            this.myRepositoryManager = repositoryManager;
        }

        @Override
        public int compare(VcsRef ref1, VcsRef ref2) {
            int power2;
            int power1 = ArrayUtil.find((Object[])this.getOrderedTypes(), (Object)((Object)this.getType(ref1)));
            if (power1 != (power2 = ArrayUtil.find((Object[])this.getOrderedTypes(), (Object)((Object)this.getType(ref2))))) {
                return power1 - power2;
            }
            int namesComparison = ref1.getName().compareTo(ref2.getName());
            if (namesComparison != 0) {
                return namesComparison;
            }
            return VcsLogUtil.compareRoots((VirtualFile)ref1.getRoot(), (VirtualFile)ref2.getRoot());
        }

        protected abstract RefType[] getOrderedTypes();

        private RefType getType(VcsRef ref) {
            VcsRefType type = ref.getType();
            if (type == HEAD) {
                return RefType.HEAD;
            }
            if (type == TAG) {
                return RefType.TAG;
            }
            if (type == LOCAL_BRANCH) {
                if (ref.getName().equals(GitRefManager.MASTER)) {
                    return RefType.MASTER;
                }
                return this.isTracked(ref, false) ? RefType.TRACKING_LOCAL_BRANCH : RefType.NON_TRACKING_LOCAL_BRANCH;
            }
            if (type == REMOTE_BRANCH) {
                if (ref.getName().equals(GitRefManager.ORIGIN_MASTER)) {
                    return RefType.ORIGIN_MASTER;
                }
                return this.isTracked(ref, true) ? RefType.TRACKED_REMOTE_BRANCH : RefType.NON_TRACKED_REMOTE_BRANCH;
            }
            return RefType.OTHER;
        }

        private boolean isTracked(final VcsRef ref, final boolean remoteBranch) {
            GitRepository repo = (GitRepository)this.myRepositoryManager.getRepositoryForRoot(ref.getRoot());
            if (repo == null) {
                LOG.error("Undefined root " + ref.getRoot());
                return false;
            }
            return ContainerUtil.exists(repo.getBranchTrackInfos(), (Condition)new Condition<GitBranchTrackInfo>(){

                public boolean value(GitBranchTrackInfo info) {
                    return remoteBranch ? info.getRemoteBranch().getNameForLocalOperations().equals(ref.getName()) : info.getLocalBranch().getName().equals(ref.getName());
                }
            });
        }
    }

    private static class GitBranchLayoutComparator
    extends GitRefComparator {
        private static final RefType[] ORDERED_TYPES = new RefType[]{RefType.ORIGIN_MASTER, RefType.TRACKED_REMOTE_BRANCH, RefType.MASTER, RefType.TRACKING_LOCAL_BRANCH, RefType.NON_TRACKING_LOCAL_BRANCH, RefType.NON_TRACKED_REMOTE_BRANCH, RefType.TAG, RefType.HEAD, RefType.OTHER};

        GitBranchLayoutComparator(RepositoryManager<GitRepository> repositoryManager) {
            super(repositoryManager);
        }

        @Override
        protected RefType[] getOrderedTypes() {
            return ORDERED_TYPES;
        }
    }

    private static class GitLabelComparator
    extends GitRefComparator {
        private static final RefType[] ORDERED_TYPES = new RefType[]{RefType.HEAD, RefType.MASTER, RefType.TRACKING_LOCAL_BRANCH, RefType.NON_TRACKING_LOCAL_BRANCH, RefType.ORIGIN_MASTER, RefType.TRACKED_REMOTE_BRANCH, RefType.NON_TRACKED_REMOTE_BRANCH, RefType.TAG, RefType.OTHER};

        GitLabelComparator(RepositoryManager<GitRepository> repositoryManager) {
            super(repositoryManager);
        }

        @Override
        protected RefType[] getOrderedTypes() {
            return ORDERED_TYPES;
        }
    }

    private class RemoteRefGroup
    implements RefGroup {
        private final GitRemote myRemote;
        private final Collection<VcsRef> myBranches;

        public RemoteRefGroup(GitRemote remote, Collection<VcsRef> branches) {
            this.myRemote = remote;
            this.myBranches = branches;
        }

        public boolean isExpanded() {
            return false;
        }

        public String getName() {
            return this.myRemote.getName() + "/...";
        }

        public List<VcsRef> getRefs() {
            return ContainerUtil.sorted(this.myBranches, GitRefManager.this.getLabelsOrderComparator());
        }

        public Color getBgColor() {
            return REMOTE_BRANCH_COLOR;
        }
    }

    private static class LogicalRefGroup
    implements RefGroup {
        private final String myGroupName;
        private final List<VcsRef> myRefs;

        private LogicalRefGroup(String groupName, List<VcsRef> refs) {
            this.myGroupName = groupName;
            this.myRefs = refs;
        }

        public boolean isExpanded() {
            return true;
        }

        public String getName() {
            return this.myGroupName;
        }

        public List<VcsRef> getRefs() {
            return this.myRefs;
        }

        public Color getBgColor() {
            return HEAD_COLOR;
        }
    }

    private static class SimpleRefType
    implements VcsRefType {
        private final boolean myIsBranch;
        private final Color myColor;

        public SimpleRefType(boolean isBranch, Color color) {
            this.myIsBranch = isBranch;
            this.myColor = color;
        }

        public boolean isBranch() {
            return this.myIsBranch;
        }

        public Color getBackgroundColor() {
            return this.myColor;
        }
    }

    protected static enum RefType {
        OTHER,
        HEAD,
        TAG,
        NON_TRACKING_LOCAL_BRANCH,
        NON_TRACKED_REMOTE_BRANCH,
        TRACKING_LOCAL_BRANCH,
        MASTER,
        TRACKED_REMOTE_BRANCH,
        ORIGIN_MASTER;

    }
}

