/*
 * Decompiled with CFR 0.152.
 */
package git4idea.merge;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import git4idea.GitPlatformFacade;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.merge.GitMergeProvider;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.util.StringScanner;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.event.HyperlinkEvent;

public class GitConflictResolver {
    private static final Logger LOG = Logger.getInstance(GitConflictResolver.class);
    protected final Project myProject;
    private final Git myGit;
    private final GitPlatformFacade myPlatformFacade;
    private final Collection<VirtualFile> myRoots;
    private final Params myParams;
    private final GitRepositoryManager myRepositoryManager;
    private final AbstractVcsHelper myVcsHelper;

    public GitConflictResolver(Project project, Git git, GitPlatformFacade platformFacade, Collection<VirtualFile> roots, Params params) {
        this.myProject = project;
        this.myGit = git;
        this.myPlatformFacade = platformFacade;
        this.myRoots = roots;
        this.myParams = params;
        this.myRepositoryManager = (GitRepositoryManager)((Object)this.myPlatformFacade.getRepositoryManager(this.myProject));
        this.myVcsHelper = this.myPlatformFacade.getVcsHelper(project);
    }

    public final boolean merge() {
        return this.merge(false);
    }

    protected boolean proceedIfNothingToMerge() throws VcsException {
        return true;
    }

    protected boolean proceedAfterAllMerged() throws VcsException {
        return true;
    }

    public final boolean mergeNoProceed() {
        return this.merge(true);
    }

    protected void notifyUnresolvedRemain() {
        this.notifyWarning(this.myParams.myErrorNotificationTitle, "You have to <a href='resolve'>resolve</a> all conflicts first." + this.myParams.myErrorNotificationAdditionalDescription);
    }

    private void notifyUnresolvedRemainAfterNotification() {
        this.notifyWarning("Not all conflicts resolved", "You should <a href='resolve'>resolve</a> all conflicts before update. <br>" + this.myParams.myErrorNotificationAdditionalDescription);
    }

    private void notifyWarning(String title, String content) {
        VcsNotifier.getInstance((Project)this.myProject).notifyImportantWarning(title, content, (NotificationListener)new ResolveNotificationListener());
    }

    private boolean merge(boolean mergeDialogInvokedFromNotification) {
        block6: {
            try {
                Collection<VirtualFile> initiallyUnmergedFiles = this.getUnmergedFiles(this.myRoots);
                if (initiallyUnmergedFiles.isEmpty()) {
                    LOG.info("merge: no unmerged files");
                    return mergeDialogInvokedFromNotification ? true : this.proceedIfNothingToMerge();
                }
                this.showMergeDialog(initiallyUnmergedFiles);
                Collection<VirtualFile> unmergedFilesAfterResolve = this.getUnmergedFiles(this.myRoots);
                if (unmergedFilesAfterResolve.isEmpty()) {
                    LOG.info("merge no more unmerged files");
                    return mergeDialogInvokedFromNotification ? true : this.proceedAfterAllMerged();
                }
                LOG.info("mergeFiles unmerged files remain: " + unmergedFilesAfterResolve);
                if (mergeDialogInvokedFromNotification) {
                    this.notifyUnresolvedRemainAfterNotification();
                } else {
                    this.notifyUnresolvedRemain();
                }
            }
            catch (VcsException e) {
                if (!((GitVcs)this.myPlatformFacade.getVcs(this.myProject)).getExecutableValidator().checkExecutableAndNotifyIfNeeded()) break block6;
                this.notifyException(e);
            }
        }
        return false;
    }

    private void showMergeDialog(final Collection<VirtualFile> initiallyUnmergedFiles) {
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                GitMergeProvider mergeProvider = GitConflictResolver.this.myParams.reverse ? new GitMergeProvider(GitConflictResolver.this.myProject, true) : new GitMergeProvider(GitConflictResolver.this.myProject, false);
                GitConflictResolver.this.myVcsHelper.showMergeDialog(new ArrayList(initiallyUnmergedFiles), (MergeProvider)mergeProvider, GitConflictResolver.this.myParams.myMergeDialogCustomizer);
            }
        });
    }

    private void notifyException(VcsException e) {
        LOG.info("mergeFiles ", (Throwable)e);
        String description = "Couldn't check the working tree for unmerged files because of an error.";
        VcsNotifier.getInstance((Project)this.myProject).notifyError(this.myParams.myErrorNotificationTitle, "Couldn't check the working tree for unmerged files because of an error." + this.myParams.myErrorNotificationAdditionalDescription + "<br/>" + e.getLocalizedMessage(), (NotificationListener)new ResolveNotificationListener());
    }

    protected NotificationListener getResolveLinkListener() {
        return new ResolveNotificationListener();
    }

    private Collection<VirtualFile> getUnmergedFiles(Collection<VirtualFile> roots) throws VcsException {
        HashSet<VirtualFile> unmergedFiles = new HashSet<VirtualFile>();
        for (VirtualFile root : roots) {
            unmergedFiles.addAll(this.getUnmergedFiles(root));
        }
        return unmergedFiles;
    }

    private Collection<VirtualFile> getUnmergedFiles(VirtualFile root) throws VcsException {
        return this.unmergedFiles(root);
    }

    private List<VirtualFile> unmergedFiles(final VirtualFile root) throws VcsException {
        GitRepository repository = (GitRepository)this.myRepositoryManager.getRepositoryForRoot(root);
        if (repository == null) {
            LOG.error("Repository not found for root " + root);
            return Collections.emptyList();
        }
        GitCommandResult result = this.myGit.getUnmergedFiles(repository);
        if (!result.success()) {
            throw new VcsException(result.getErrorOutputAsJoinedString());
        }
        String output = StringUtil.join(result.getOutput(), (String)"\n");
        HashSet unmergedPaths = ContainerUtil.newHashSet();
        StringScanner s = new StringScanner(output);
        while (s.hasMoreData()) {
            if (s.isEol()) {
                s.nextLine();
                continue;
            }
            s.boundedToken('\t');
            String relative = s.line();
            unmergedPaths.add(GitUtil.unescapePath(relative));
        }
        if (unmergedPaths.size() == 0) {
            return Collections.emptyList();
        }
        List files = ContainerUtil.map((Collection)unmergedPaths, (Function)new Function<String, File>(){

            public File fun(String path) {
                return new File(root.getPath(), path);
            }
        });
        return ContainerUtil.sorted((Collection)RefreshVFsSynchronously.refreshFiles((Collection)files), GitUtil.VIRTUAL_FILE_COMPARATOR);
    }

    private class ResolveNotificationListener
    implements NotificationListener {
        private ResolveNotificationListener() {
        }

        public void hyperlinkUpdate(Notification notification, HyperlinkEvent event) {
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && event.getDescription().equals("resolve")) {
                notification.expire();
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                    @Override
                    public void run() {
                        GitConflictResolver.this.mergeNoProceed();
                    }
                });
            }
        }
    }

    public static class Params {
        private boolean reverse;
        private String myErrorNotificationTitle = "";
        private String myErrorNotificationAdditionalDescription = "";
        private String myMergeDescription = "";
        private MergeDialogCustomizer myMergeDialogCustomizer = new MergeDialogCustomizer(){

            public String getMultipleFileMergeDescription(Collection<VirtualFile> files) {
                return Params.this.myMergeDescription;
            }
        };

        public Params setReverse(boolean reverseMerge) {
            this.reverse = reverseMerge;
            return this;
        }

        public Params setErrorNotificationTitle(String errorNotificationTitle) {
            this.myErrorNotificationTitle = errorNotificationTitle;
            return this;
        }

        public Params setErrorNotificationAdditionalDescription(String errorNotificationAdditionalDescription) {
            this.myErrorNotificationAdditionalDescription = errorNotificationAdditionalDescription;
            return this;
        }

        public Params setMergeDescription(String mergeDescription) {
            this.myMergeDescription = mergeDescription;
            return this;
        }

        public Params setMergeDialogCustomizer(MergeDialogCustomizer mergeDialogCustomizer) {
            this.myMergeDialogCustomizer = mergeDialogCustomizer;
            return this;
        }
    }
}

