/*
 * Decompiled with CFR 0.152.
 */
package git4idea.merge;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitPlatformFacade;
import git4idea.commands.Git;
import git4idea.merge.GitConflictResolver;
import git4idea.merge.GitMerger;
import java.util.Collection;

public class GitMergeCommittingConflictResolver
extends GitConflictResolver {
    private final Collection<VirtualFile> myMergingRoots;
    private final boolean myRefreshAfterCommit;
    private final GitMerger myMerger;

    public GitMergeCommittingConflictResolver(Project project, Git git, GitMerger merger, Collection<VirtualFile> mergingRoots, GitConflictResolver.Params params, boolean refreshAfterCommit) {
        super(project, git, (GitPlatformFacade)ServiceManager.getService(GitPlatformFacade.class), mergingRoots, params);
        this.myMerger = merger;
        this.myMergingRoots = mergingRoots;
        this.myRefreshAfterCommit = refreshAfterCommit;
    }

    @Override
    protected boolean proceedAfterAllMerged() throws VcsException {
        this.myMerger.mergeCommit(this.myMergingRoots);
        if (this.myRefreshAfterCommit) {
            for (VirtualFile root : this.myMergingRoots) {
                root.refresh(true, true);
            }
        }
        return true;
    }
}

