/*
 * Decompiled with CFR 0.152.
 */
package git4idea.merge;

import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeData;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vcs.merge.MergeProvider2;
import com.intellij.openapi.vcs.merge.MergeSession;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsRunnable;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitFileRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.commands.GitCommand;
import git4idea.commands.GitSimpleHandler;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.util.GitFileUtils;
import git4idea.util.StringScanner;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GitMergeProvider
implements MergeProvider2 {
    private static final int ORIGINAL_REVISION_NUM = 1;
    private static final int YOURS_REVISION_NUM = 2;
    private static final int THEIRS_REVISION_NUM = 3;
    private static final Logger LOG = Logger.getInstance(GitMergeProvider.class);
    private final Project myProject;
    private final Set<VirtualFile> myReverseRoots;

    private GitMergeProvider(Project project, Set<VirtualFile> reverseRoots) {
        this.myProject = project;
        this.myReverseRoots = reverseRoots;
    }

    public GitMergeProvider(Project project, boolean reverse) {
        this(project, GitMergeProvider.findReverseRoots(project, reverse ? ReverseRequest.REVERSE : ReverseRequest.FORWARD));
    }

    public static MergeProvider detect(Project project) {
        return new GitMergeProvider(project, GitMergeProvider.findReverseRoots(project, ReverseRequest.DETECT));
    }

    private static Set<VirtualFile> findReverseRoots(Project project, ReverseRequest reverseOrDetect) {
        HashSet reverseMap = ContainerUtil.newHashSet();
        for (GitRepository repository : GitUtil.getRepositoryManager(project).getRepositories()) {
            boolean reverse;
            if (reverseOrDetect == ReverseRequest.DETECT) {
                reverse = repository.getState().equals((Object)Repository.State.REBASING);
            } else {
                boolean bl = reverse = reverseOrDetect == ReverseRequest.REVERSE;
            }
            if (!reverse) continue;
            reverseMap.add(repository.getRoot());
        }
        return reverseMap;
    }

    public MergeData loadRevisions(final VirtualFile file) throws VcsException {
        final MergeData mergeData = new MergeData();
        final VirtualFile root = GitUtil.getGitRoot(file);
        final FilePath path = VcsUtil.getFilePath((String)file.getPath());
        VcsRunnable runnable = new VcsRunnable(){

            public void run() throws VcsException {
                GitFileRevision original = new GitFileRevision(GitMergeProvider.this.myProject, path, new GitRevisionNumber(":1"));
                GitFileRevision current = new GitFileRevision(GitMergeProvider.this.myProject, path, new GitRevisionNumber(":" + GitMergeProvider.this.yoursRevision(root)));
                GitFileRevision last = new GitFileRevision(GitMergeProvider.this.myProject, path, new GitRevisionNumber(":" + GitMergeProvider.this.theirsRevision(root)));
                try {
                    try {
                        mergeData.ORIGINAL = original.getContent();
                    }
                    catch (Exception ex) {
                        mergeData.ORIGINAL = file.contentsToByteArray();
                    }
                    mergeData.CURRENT = GitMergeProvider.loadRevisionCatchingErrors(current);
                    mergeData.LAST = GitMergeProvider.loadRevisionCatchingErrors(last);
                    mergeData.LAST_REVISION_NUMBER = GitMergeProvider.this.findLastRevisionNumber(root);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to load file content", e);
                }
            }
        };
        VcsUtil.runVcsProcessWithProgress((VcsRunnable)runnable, (String)GitBundle.message("merge.load.files", new Object[0]), (boolean)false, (Project)this.myProject);
        return mergeData;
    }

    private VcsRevisionNumber findLastRevisionNumber(VirtualFile root) {
        if (this.myReverseRoots.contains(root)) {
            return this.resolveHead(root);
        }
        try {
            return GitRevisionNumber.resolve(this.myProject, root, "MERGE_HEAD");
        }
        catch (VcsException e) {
            LOG.info("Couldn't resolve the MERGE_HEAD in " + root, (Throwable)e);
            try {
                return GitRevisionNumber.resolve(this.myProject, root, "CHERRY_PICK_HEAD");
            }
            catch (VcsException e1) {
                LOG.info("Couldn't resolve neither MERGE_HEAD, nor the CHERRY_PICK_HEAD in " + root, (Throwable)e1);
                return this.resolveHead(root);
            }
        }
    }

    private GitRevisionNumber resolveHead(VirtualFile root) {
        try {
            return GitRevisionNumber.resolve(this.myProject, root, "HEAD");
        }
        catch (VcsException e) {
            LOG.error("Couldn't resolve the HEAD in " + root, (Throwable)e);
            return null;
        }
    }

    private static byte[] loadRevisionCatchingErrors(GitFileRevision revision) throws VcsException, IOException {
        try {
            return revision.getContent();
        }
        catch (VcsException e) {
            String m = e.getMessage().trim();
            if (m.startsWith("fatal: ambiguous argument ") || m.startsWith("fatal: Path '") && m.contains("' exists on disk, but not in '") || m.contains("is in the index, but not at stage ")) {
                return ArrayUtil.EMPTY_BYTE_ARRAY;
            }
            throw e;
        }
    }

    private int yoursRevision(VirtualFile root) {
        return this.myReverseRoots.contains(root) ? 3 : 2;
    }

    private int theirsRevision(VirtualFile root) {
        return this.myReverseRoots.contains(root) ? 2 : 3;
    }

    public void conflictResolvedForFile(VirtualFile file) {
        try {
            GitFileUtils.addFiles(this.myProject, GitUtil.getGitRoot(file), file);
        }
        catch (VcsException e) {
            LOG.error("Confirming conflict resolution failed", (Throwable)e);
        }
    }

    public boolean isBinary(VirtualFile file) {
        return file.getFileType().isBinary();
    }

    public MergeSession createMergeSession(List<VirtualFile> files) {
        return new MyMergeSession(files);
    }

    private class MyMergeSession
    implements MergeSession {
        Map<VirtualFile, Conflict> myConflicts = new HashMap<VirtualFile, Conflict>();

        MyMergeSession(List<VirtualFile> filesToMerge) {
            try {
                for (Map.Entry<VirtualFile, List<VirtualFile>> e : GitUtil.sortFilesByGitRoot(filesToMerge).entrySet()) {
                    HashMap<String, Conflict> cs = new HashMap<String, Conflict>();
                    VirtualFile root = e.getKey();
                    List<VirtualFile> files = e.getValue();
                    GitSimpleHandler h = new GitSimpleHandler(GitMergeProvider.this.myProject, root, GitCommand.LS_FILES);
                    h.setStdoutSuppressed(true);
                    h.setSilent(true);
                    h.addParameters("--exclude-standard", "--unmerged", "-t", "-z");
                    h.endOptions();
                    String output = h.run();
                    StringScanner s = new StringScanner(output);
                    while (s.hasMoreData()) {
                        if (!"M".equals(s.spaceToken())) {
                            s.boundedToken('\u0000');
                            continue;
                        }
                        s.spaceToken();
                        s.spaceToken();
                        int source = Integer.parseInt(s.tabToken());
                        String file = s.boundedToken('\u0000');
                        Conflict c = (Conflict)cs.get(file);
                        if (c == null) {
                            c = new Conflict();
                            c.myRoot = root;
                            cs.put(file, c);
                        }
                        if (source == GitMergeProvider.this.theirsRevision(root)) {
                            c.myStatusTheirs = Conflict.Status.MODIFIED;
                            continue;
                        }
                        if (source == GitMergeProvider.this.yoursRevision(root)) {
                            c.myStatusYours = Conflict.Status.MODIFIED;
                            continue;
                        }
                        if (source == 1) continue;
                        throw new IllegalStateException("Unknown revision " + source + " for the file: " + file);
                    }
                    for (VirtualFile f : files) {
                        String path = VcsFileUtil.relativePath((VirtualFile)root, (VirtualFile)f);
                        Conflict c = (Conflict)cs.get(path);
                        LOG.assertTrue(c != null, (Object)String.format("The conflict not found for file: %s(%s)%nFull ls-files output: %n%s%nAll files: %n%s", f.getPath(), path, output, files));
                        c.myFile = f;
                        if (c.myStatusTheirs == null) {
                            c.myStatusTheirs = Conflict.Status.DELETED;
                        }
                        if (c.myStatusYours == null) {
                            c.myStatusYours = Conflict.Status.DELETED;
                        }
                        this.myConflicts.put(f, c);
                    }
                }
            }
            catch (VcsException ex) {
                throw new IllegalStateException("The git operation should not fail in this context", ex);
            }
        }

        public ColumnInfo[] getMergeInfoColumns() {
            return new ColumnInfo[]{new StatusColumn(false), new StatusColumn(true)};
        }

        public boolean canMerge(VirtualFile file) {
            Conflict c = this.myConflicts.get(file);
            return c != null;
        }

        public void conflictResolvedForFile(VirtualFile file, MergeSession.Resolution resolution) {
            Conflict c = this.myConflicts.get(file);
            assert (c != null) : "Conflict was not loaded for the file: " + file.getPath();
            try {
                Conflict.Status status;
                switch (resolution) {
                    case AcceptedTheirs: {
                        status = c.myStatusTheirs;
                        break;
                    }
                    case AcceptedYours: {
                        status = c.myStatusYours;
                        break;
                    }
                    case Merged: {
                        status = Conflict.Status.MODIFIED;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported resolution for unmergable files(" + file.getPath() + "): " + resolution);
                    }
                }
                switch (status) {
                    case MODIFIED: {
                        GitFileUtils.addFiles(GitMergeProvider.this.myProject, c.myRoot, file);
                        break;
                    }
                    case DELETED: {
                        GitFileUtils.deleteFiles(GitMergeProvider.this.myProject, c.myRoot, file);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported status(" + file.getPath() + "): " + (Object)((Object)status));
                    }
                }
            }
            catch (VcsException e) {
                LOG.error("Unexpected exception during the git operation (" + file.getPath() + ")", (Throwable)e);
            }
        }

        class StatusColumn
        extends ColumnInfo<VirtualFile, String> {
            private final boolean myIsTheirs;

            public StatusColumn(boolean isTheirs) {
                super(isTheirs ? GitBundle.message("merge.tool.column.theirs.status", new Object[0]) : GitBundle.message("merge.tool.column.yours.status", new Object[0]));
                this.myIsTheirs = isTheirs;
            }

            public String valueOf(VirtualFile file) {
                Conflict c = MyMergeSession.this.myConflicts.get(file);
                assert (c != null) : "No conflict for the file " + file;
                Conflict.Status s = this.myIsTheirs ? c.myStatusTheirs : c.myStatusYours;
                switch (s) {
                    case MODIFIED: {
                        return GitBundle.message("merge.tool.column.status.modified", new Object[0]);
                    }
                    case DELETED: {
                        return GitBundle.message("merge.tool.column.status.deleted", new Object[0]);
                    }
                }
                throw new IllegalStateException("Unknown status " + (Object)((Object)s) + " for file " + file.getPath());
            }

            public String getMaxStringValue() {
                return GitBundle.message("merge.tool.column.status.modified", new Object[0]);
            }

            public int getAdditionalWidth() {
                return 10;
            }
        }
    }

    private static class Conflict {
        VirtualFile myFile;
        VirtualFile myRoot;
        Status myStatusTheirs;
        Status myStatusYours;

        private Conflict() {
        }

        static enum Status {
            MODIFIED,
            DELETED;

        }
    }

    private static enum ReverseRequest {
        REVERSE,
        FORWARD,
        DETECT;

    }
}

